/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.spi.security;

import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class AnnotationHandler
implements InternalSecurityManager.CommitHandler {
    public static final String SOURCE_URI = "http://www.eclipse.org/CDO/Security";
    public static final String READ_KEY = "read";
    public static final String WRITE_KEY = "write";
    public static final String DELIMITERS = " ,;|";

    public void init(InternalSecurityManager securityManager, boolean firstTime) {
        if (firstTime) {
            CDOPackageRegistry packageRegistry = securityManager.getRepository().getPackageRegistry();
            this.handlePackageUnits(securityManager, packageRegistry.getPackageUnits());
        }
    }

    public void handleCommit(InternalSecurityManager securityManager, IStoreAccessor.CommitContext commitContext, User user) {
        this.handlePackageUnits(securityManager, (CDOPackageUnit[])commitContext.getNewPackageUnits());
    }

    protected void handlePackageUnits(InternalSecurityManager securityManager, final CDOPackageUnit[] packageUnits) {
        securityManager.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                if (packageUnits != null && packageUnits.length != 0) {
                    CDOPackageUnit[] cDOPackageUnitArray = packageUnits;
                    int n = packageUnits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOPackageUnit packageUnit = cDOPackageUnitArray[n2];
                        CDOPackageInfo[] cDOPackageInfoArray = packageUnit.getPackageInfos();
                        int n3 = cDOPackageInfoArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            CDOPackageInfo packageInfo = cDOPackageInfoArray[n4];
                            EPackage ePackage = packageInfo.getEPackage();
                            AnnotationHandler.this.handlePackage(realm, ePackage);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void handlePackage(Realm realm, EPackage ePackage) {
        this.handlePackagePermission(realm, ePackage, READ_KEY, Access.READ);
        this.handlePackagePermission(realm, ePackage, WRITE_KEY, Access.WRITE);
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            this.handleClassPermission(realm, eClass, READ_KEY, Access.READ);
            this.handleClassPermission(realm, eClass, WRITE_KEY, Access.WRITE);
        }
    }

    protected void handlePackagePermission(Realm realm, EPackage ePackage, String key, Access access) {
        EClass filterClass = SecurityPackage.Literals.PACKAGE_FILTER;
        EReference filterFeature = SecurityPackage.Literals.PACKAGE_FILTER__APPLICABLE_PACKAGE;
        this.handlePermission(realm, (EModelElement)ePackage, key, access, filterClass, filterFeature);
    }

    protected void handleClassPermission(Realm realm, EClass eClass, String key, Access access) {
        EClass filterClass = SecurityPackage.Literals.CLASS_FILTER;
        EReference filterFeature = SecurityPackage.Literals.CLASS_FILTER__APPLICABLE_CLASS;
        this.handlePermission(realm, (EModelElement)eClass, key, access, filterClass, filterFeature);
    }

    protected void handlePermission(Realm realm, EModelElement modelElement, String key, Access access, EClass filterClass, EReference filterFeature) {
        String annotation = EcoreUtil.getAnnotation((EModelElement)modelElement, (String)SOURCE_URI, (String)key);
        if (annotation == null || annotation.length() == 0) {
            return;
        }
        EList items = realm.getItems();
        StringTokenizer tokenizer = new StringTokenizer(annotation, DELIMITERS);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || token.length() == 0) continue;
            PermissionFilter filter = (PermissionFilter)EcoreUtil.create((EClass)filterClass);
            filter.eSet((EStructuralFeature)filterFeature, (Object)modelElement);
            FilterPermission permission = SecurityFactory.eINSTANCE.createFilterPermission(access, new PermissionFilter[]{filter});
            Role role = RealmUtil.findRole((EList)items, (String)token);
            if (role == null) {
                role = SecurityFactory.eINSTANCE.createRole();
                role.setId(token);
                items.add((Object)role);
            }
            role.getPermissions().add((Object)permission);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    extends InternalSecurityManager.CommitHandler.Factory {
        public Factory() {
            super("annotation");
        }

        public InternalSecurityManager.CommitHandler create(String description) throws ProductCreationException {
            return new AnnotationHandler();
        }
    }
}

