/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin.wizards;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.ui.internal.admin.bundle.OM;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateRepositoryWizardPage
extends WizardPage {
    private Whiteboard whiteboard;

    public AbstractCreateRepositoryWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        this.createContents(composite);
        this.setControl((Control)composite);
        this.loadSettings(this.getDialogSettings());
        this.hookListeners();
    }

    protected abstract void createContents(Composite var1);

    protected void hookListeners() {
        this.hookListeners(new Listener(){

            public void handleEvent(Event event) {
                AbstractCreateRepositoryWizardPage.this.updateEnablement(false);
            }
        });
        this.updateEnablement(true);
    }

    protected void hookListeners(Listener updateListener) {
    }

    protected void updateEnablement(boolean firstTime) {
        this.setPageComplete(true);
    }

    boolean performFinish(Map<String, Object> repositoryProperties) {
        boolean result = this.collectRepositoryProperties(repositoryProperties);
        this.saveSettings(this.getDialogSettings());
        return result;
    }

    protected abstract boolean collectRepositoryProperties(Map<String, Object> var1);

    protected void loadSettings(IDialogSettings pageSettings) {
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings wizardSettings = super.getDialogSettings();
        return wizardSettings == null ? null : DialogSettings.getOrCreateSection((IDialogSettings)wizardSettings, (String)this.getName());
    }

    protected String getSetting(IDialogSettings pageSettings, String key, String defaultValue) {
        return pageSettings.get(key) == null ? defaultValue : pageSettings.get(key);
    }

    protected boolean getSetting(IDialogSettings pageSettings, String key, boolean defaultValue) {
        return pageSettings.get(key) == null ? defaultValue : pageSettings.getBoolean(key);
    }

    protected void saveSettings(IDialogSettings pageSettings) {
    }

    protected Group group(Composite parent, String label) {
        Group result = new Group(parent, 2048);
        result.setText(label);
        result.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        result.setLayout((Layout)new GridLayout(2, false));
        return result;
    }

    protected Text text(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text result = new Text(parent, 2048);
        result.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        return result;
    }

    protected Button checkbox(Composite parent, String label) {
        Button result = new Button(parent, 32);
        result.setText(label);
        result.setLayoutData((Object)UIUtil.createGridData((int)2, (int)1));
        return result;
    }

    protected ComboViewer combo(Composite parent, String label, Object input) {
        new Label(parent, 0).setText(label);
        ComboViewer result = new ComboViewer(parent, 12);
        result.setContentProvider((IContentProvider)new ArrayContentProvider());
        result.setInput(input);
        return result;
    }

    protected boolean checked(Button checkbox) {
        return checkbox.isEnabled() && checkbox.getSelection();
    }

    protected String text(Text text) {
        return text.getText().trim();
    }

    protected boolean positiveInteger(String value) {
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected final void publish(Object topic) {
        if (this.whiteboard != null && topic != null) {
            this.whiteboard.publish(topic);
        }
    }

    final void bind(Whiteboard whiteboard) {
        if (this.whiteboard != null) {
            throw new IllegalStateException("already bound to a whiteboard");
        }
        this.whiteboard = whiteboard;
        whiteboard.subscribe((Object)this);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Subscribe {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Whiteboard {
        private List<Object> subscribers = new ArrayList<Object>();

        public void publish(Object topic) {
            for (Object subscriber : this.subscribers) {
                Method handler = this.getHandler(subscriber, topic.getClass());
                if (handler == null) continue;
                try {
                    handler.invoke(subscriber, topic);
                }
                catch (Exception e) {
                    OM.LOG.error((Throwable)e);
                }
            }
        }

        void subscribe(Object subscriber) {
            this.subscribers.add(subscriber);
        }

        private Method getHandler(Object subscriber, Class<?> topicType) {
            Method[] methodArray = subscriber.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] parameterTypes;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(Subscribe.class) && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0].isAssignableFrom(topicType)) {
                    return method;
                }
                ++n2;
            }
            return null;
        }
    }
}

