/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.handlers;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockingHandler
extends AbstractBaseHandler<EObject> {
    private final CDOLockChangeInfo.Operation operation;
    private final boolean recursive;

    public LockingHandler(CDOLockChangeInfo.Operation operation, boolean recursive) {
        super(EObject.class, null);
        this.operation = operation;
        this.recursive = recursive;
    }

    protected void doExecute(IProgressMonitor monitor) throws Exception {
        CDOView view = null;
        HashSet<CDOObject> objects = new HashSet<CDOObject>();
        for (EObject element : this.elements) {
            CDOView objectView;
            CDOObject object = CDOUtil.getCDOObject((EObject)element);
            if (object == null || (objectView = object.cdoView()) == null) continue;
            if (view == null) {
                view = objectView;
            } else if (view != objectView) {
                return;
            }
            objects.add(object);
        }
        if (this.operation == CDOLockChangeInfo.Operation.LOCK) {
            view.lockObjects(objects, IRWLockManager.LockType.WRITE, 5000L, this.recursive);
        } else {
            view.unlockObjects(objects, IRWLockManager.LockType.WRITE, this.recursive);
        }
    }

    public static final class LockObject
    extends LockingHandler {
        public LockObject() {
            super(CDOLockChangeInfo.Operation.LOCK, false);
        }
    }

    public static final class LockTree
    extends LockingHandler {
        public LockTree() {
            super(CDOLockChangeInfo.Operation.LOCK, true);
        }
    }

    public static final class UnlockObject
    extends LockingHandler {
        public UnlockObject() {
            super(CDOLockChangeInfo.Operation.UNLOCK, false);
        }
    }

    public static final class UnlockTree
    extends LockingHandler {
        public UnlockTree() {
            super(CDOLockChangeInfo.Operation.UNLOCK, true);
        }
    }
}

