/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOObjectReferenceImpl
implements CDOObjectReference {
    private CDOView view;
    private CDOIDReference delegate;

    public CDOObjectReferenceImpl(CDOView view, CDOIDReference delegate) {
        this.view = view;
        this.delegate = delegate;
    }

    public CDOObject getTargetObject() {
        return this.view.getObject(this.getTargetID());
    }

    public CDOID getTargetID() {
        return this.delegate.getTargetObject();
    }

    public CDOObject getSourceObject() {
        return this.view.getObject(this.getSourceID());
    }

    public CDOID getSourceID() {
        return this.delegate.getSourceObject();
    }

    public EStructuralFeature getSourceFeature() {
        return this.delegate.getSourceFeature();
    }

    public int getSourceIndex() {
        return this.delegate.getSourceIndex();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSourceObject());
        builder.append(".");
        builder.append(this.getSourceFeature().getName());
        int sourceIndex = this.getSourceIndex();
        if (sourceIndex != -1) {
            builder.append("[");
            builder.append(sourceIndex);
            builder.append("]");
        }
        builder.append(" --> ");
        builder.append(this.getTargetObject());
        return builder.toString();
    }
}

