/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.common;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.diffmerge.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;

public class FHashSet<E>
extends AbstractSet<E>
implements IEqualityBasedStructure {
    private FHashMap<E, Object> _mappedContents;
    private static final Object PRESENT = new Object();

    public FHashSet() {
        this(null);
    }

    public FHashSet(IEqualityTester tester_p) {
        this._mappedContents = new FHashMap(tester_p);
    }

    public FHashSet(Collection<? extends E> collection_p, IEqualityTester tester_p) {
        this._mappedContents = new FHashMap(Math.max((int)((float)collection_p.size() / 0.75f) + 1, 16), tester_p);
        this.addAll(collection_p);
    }

    public FHashSet(int initialCapacity_p, IEqualityTester tester_p) {
        this._mappedContents = new FHashMap(initialCapacity_p, tester_p);
    }

    @Override
    public boolean add(E element_p) {
        return this._mappedContents.put(element_p, PRESENT) == null;
    }

    @Override
    public void clear() {
        this._mappedContents.clear();
    }

    @Override
    public boolean contains(Object element_p) {
        return this._mappedContents.containsKey(element_p);
    }

    @Override
    public IEqualityTester getEqualityTester() {
        return this._mappedContents.getEqualityTester();
    }

    @Override
    public boolean isEmpty() {
        return this._mappedContents.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new WrappingIterator(this._mappedContents.iterator());
    }

    @Override
    public boolean remove(Object element_p) {
        return this._mappedContents.removeKey(element_p) == PRESENT;
    }

    @Override
    public int size() {
        return this._mappedContents.size();
    }

    protected static class WrappingIterator<E>
    implements Iterator<E> {
        protected final Iterator<Map.Entry<E, Object>> _wrapped;

        public WrappingIterator(Iterator<Map.Entry<E, Object>> wrapped_p) {
            this._wrapped = wrapped_p;
        }

        @Override
        public boolean hasNext() {
            return this._wrapped.hasNext();
        }

        @Override
        public E next() {
            return this._wrapped.next().getKey();
        }

        @Override
        public void remove() {
            this._wrapped.remove();
        }
    }
}

