/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.context.impl.EReferencePropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.services.LockPolicyProviderService;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesContextService;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.policies.ILockPolicy;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionContentProvider;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionMessageManager;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionViewer;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesEditionWizard
extends Wizard {
    protected EditPropertyWizardPage mainPage;
    protected ElementCreationWizardPage elementCreationPage;
    protected PropertiesEditingContext editingContext;
    protected EObject eObject;
    protected EReference eReference;
    protected Command command;
    private PropertiesEditionMessageManager messageManager;
    protected AdapterFactory adapterFactory;

    public PropertiesEditionWizard(PropertiesEditingContext editionContext, AdapterFactory adapterFactory, EObject eObject) {
        this.editingContext = editionContext;
        this.eObject = eObject;
        this.adapterFactory = adapterFactory;
        this.setWindowTitle(eObject.eClass().getName());
        this.initMessageManager();
    }

    public PropertiesEditionWizard(PropertiesEditingContext editingContext, AdapterFactory adapterFactory, EReference eReference) {
        this.editingContext = editingContext;
        this.eReference = eReference;
        this.adapterFactory = adapterFactory;
        this.setWindowTitle(eReference.getName());
        this.initMessageManager();
    }

    private void initMessageManager() {
        this.messageManager = new PropertiesEditionMessageManager(){

            protected void updateStatus(String message) {
                if (PropertiesEditionWizard.this.mainPage != null) {
                    if (message == null || "".equals(message)) {
                        PropertiesEditionWizard.this.mainPage.setErrorMessage(null);
                        PropertiesEditionWizard.this.mainPage.setPageComplete(true);
                    } else {
                        PropertiesEditionWizard.this.mainPage.setErrorMessage(message);
                        PropertiesEditionWizard.this.mainPage.setPageComplete(false);
                    }
                }
            }
        };
    }

    public EditingDomain getEditingDomain() {
        return this.editingContext instanceof DomainPropertiesEditionContext ? ((DomainPropertiesEditionContext)this.editingContext).getEditingDomain() : null;
    }

    public EObject getEObject() {
        return this.eObject != null ? this.eObject : this.editingContext.getEObject();
    }

    public Command getCommand() {
        return this.command;
    }

    public void addListener(IPropertiesEditionListener listener) {
        int i = 0;
        while (i < this.getPages().length) {
            if (this.getPages()[i] instanceof EditPropertyWizardPage) {
                ((EditPropertyWizardPage)this.getPages()[i]).viewer.addPropertiesListener(listener);
            }
            ++i;
        }
    }

    public boolean performCancel() {
        this.release();
        PropertiesContextService.getInstance().pop();
        return super.performCancel();
    }

    public boolean performFinish() {
        return true;
    }

    private void release() {
        IPropertiesEditionComponent propertiesEditingComponent;
        Object input = this.mainPage.viewer.getInput();
        if (input instanceof EObjectPropertiesEditionContext && (propertiesEditingComponent = ((EObjectPropertiesEditionContext)input).getPropertiesEditingComponent()) != null) {
            for (ILockPolicy lockPolicies : LockPolicyProviderService.getInstance().getPolicies()) {
                lockPolicies.release(propertiesEditingComponent);
            }
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.mainPage.setInput(this.eObject);
        this.lock();
    }

    private void lock() {
        IPropertiesEditionComponent propertiesEditingComponent;
        Object input = this.mainPage.viewer.getInput();
        if (input instanceof EObjectPropertiesEditionContext && (propertiesEditingComponent = ((EObjectPropertiesEditionContext)input).getPropertiesEditingComponent()) != null) {
            for (ILockPolicy lockPolicies : LockPolicyProviderService.getInstance().getPolicies()) {
                lockPolicies.lock(propertiesEditingComponent);
            }
        }
    }

    public void addPages() {
        if (this.inReferenceMode()) {
            List<EClass> instanciableTypes = this.getInstanciableTypes();
            if (instanciableTypes.size() == 1) {
                EObject create = EcoreUtil.create((EClass)instanciableTypes.get(0));
                this.editingContext.seteObject(create);
                this.eObject = create;
                if (this.editingContext instanceof EReferencePropertiesEditionContext) {
                    if (((EReferencePropertiesEditionContext)this.editingContext).getSettings() != null) {
                        EEFUtils.putToReference(((EReferencePropertiesEditionContext)this.editingContext).getSettings(), create);
                    }
                    this.setWindowTitle(this.eObject.eClass().getName());
                }
            } else {
                this.elementCreationPage = new ElementCreationWizardPage();
                this.elementCreationPage.setInstanciableTypes(instanciableTypes);
                this.addPage((IWizardPage)this.elementCreationPage);
            }
        }
        this.mainPage = new EditPropertyWizardPage();
        this.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    protected boolean inReferenceMode() {
        return this.eReference != null && this.eReference.isContainment() && this.eObject == null;
    }

    protected List<EClass> getInstanciableTypes() {
        List<EClass> instanciableTypesInHierarchy = this.getInstanciableTypesInHierarchy();
        List<Object> filteredInstanciableTypesInHierarchy = new ArrayList();
        if (this.editingContext instanceof EReferencePropertiesEditionContext) {
            Collection<EReferencePropertiesEditionContext.InstanciableTypeFilter> instanciableTypeFilters = ((EReferencePropertiesEditionContext)this.editingContext).getInstanciableTypeFilters();
            if (instanciableTypeFilters.isEmpty()) {
                filteredInstanciableTypesInHierarchy = instanciableTypesInHierarchy;
            } else {
                block0: for (EClass instanciableType : instanciableTypesInHierarchy) {
                    for (EReferencePropertiesEditionContext.InstanciableTypeFilter instanciableTypeFilter : instanciableTypeFilters) {
                        if (!instanciableTypeFilter.select(instanciableType)) continue;
                        filteredInstanciableTypesInHierarchy.add(instanciableType);
                        continue block0;
                    }
                }
            }
        } else {
            filteredInstanciableTypesInHierarchy = instanciableTypesInHierarchy;
        }
        return filteredInstanciableTypesInHierarchy;
    }

    public Collection<EClass> listOfInstanciableType(AdapterFactory adapterFactory, EObject editedObject, EReference eReference) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (adapterFactory != null) {
            IEditingDomainItemProvider adapt = (IEditingDomainItemProvider)adapterFactory.adapt((Notifier)editedObject, IEditingDomainItemProvider.class);
            Collection newChildDescriptors = adapt.getNewChildDescriptors((Object)editedObject, null, null);
            for (Object object : newChildDescriptors) {
                if (!(object instanceof CommandParameter)) continue;
                CommandParameter commandParameter = (CommandParameter)object;
                if (!this.equals((EStructuralFeature)commandParameter.feature, (EStructuralFeature)eReference) || !(commandParameter.value instanceof EObject)) continue;
                result.add(((EObject)commandParameter.value).eClass());
            }
        } else {
            EClass eReferenceType;
            EClass container = eReferenceType = eReference.getEReferenceType();
            while (container.eContainer() != null) {
                container = container.eContainer();
            }
            TreeIterator eAllContents = container.eAllContents();
            while (eAllContents.hasNext()) {
                EClass eClass;
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof EClass) || (eClass = (EClass)next).isAbstract() || !eReferenceType.isSuperTypeOf(eClass)) continue;
                result.add(eClass);
            }
        }
        return result;
    }

    public boolean equals(EClass eClass1, EClass eClass2) {
        EClassifier mappedEClass2;
        EClassifier mappedEClass1;
        EPackage ePackage;
        if (eClass1.equals(eClass2)) {
            return true;
        }
        if (eClass1.eResource().getURI().isPlatform() && !eClass2.eResource().getURI().isPlatform() && (ePackage = EPackage.Registry.INSTANCE.getEPackage(eClass1.getEPackage().getNsURI())) != null && eClass2.equals(mappedEClass1 = ePackage.getEClassifier(eClass1.getName()))) {
            return true;
        }
        return !eClass1.eResource().getURI().isPlatform() && eClass2.eResource().getURI().isPlatform() && (ePackage = EPackage.Registry.INSTANCE.getEPackage(eClass2.getEPackage().getNsURI())) != null && eClass1.equals(mappedEClass2 = ePackage.getEClassifier(eClass2.getName()));
    }

    public boolean equals(EStructuralFeature esf1, EStructuralFeature esf2) {
        return this.equals(esf1.eClass(), esf2.eClass()) && esf1.getName().equals(esf2.getName());
    }

    protected List<EClass> getInstanciableTypesInHierarchy() {
        List<EClass> instanciableTypesInHierarchy;
        if (this.editingContext instanceof DomainPropertiesEditionContext) {
            instanciableTypesInHierarchy = EEFUtils.allTypeFor(this.eReference, ((DomainPropertiesEditionContext)this.editingContext).getEditingDomain());
            this.editingContext = null;
        } else {
            Collection<EClass> listOfInstanciableType = this.listOfInstanciableType(this.editingContext.getAdapterFactory(), this.editingContext.getEObject(), this.eReference);
            instanciableTypesInHierarchy = new ArrayList<EClass>(listOfInstanciableType);
        }
        return instanciableTypesInHierarchy;
    }

    protected class EditPropertyWizardPage
    extends WizardPage
    implements IPropertiesEditionListener {
        protected PropertiesEditionViewer viewer;

        protected EditPropertyWizardPage() {
            super(EEFRuntimeUIMessages.PropertiesEditionWizard_main_page_key);
        }

        public void createControl(Composite parent) {
            try {
                Composite parentComposite = new Composite(parent, 0);
                FillLayout layout = new FillLayout();
                layout.marginHeight = -5;
                layout.marginWidth = -5;
                parentComposite.setLayout((Layout)layout);
                ScrolledComposite scrolledContainer = new ScrolledComposite(parentComposite, 768);
                scrolledContainer.setExpandHorizontal(true);
                scrolledContainer.setExpandVertical(true);
                Composite container = new Composite((Composite)scrolledContainer, 0x800000);
                GridLayout containerLayout = new GridLayout();
                container.setLayout((Layout)containerLayout);
                ResourceSet resourceSet = PropertiesEditionWizard.this.editingContext != null ? PropertiesEditionWizard.this.editingContext.getResourceSet() : PropertiesEditionWizard.this.eObject.eResource().getResourceSet();
                this.viewer = new PropertiesEditionViewer(container, resourceSet, 0);
                this.viewer.setDynamicTabHeader(true);
                this.viewer.setContentProvider((IContentProvider)new PropertiesEditionContentProvider(PropertiesEditionWizard.this.adapterFactory, "Batch"));
                scrolledContainer.setContent((Control)container);
                this.setControl((Control)parentComposite);
            }
            catch (InstantiationException e) {
                EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionWizard_error_wizard_live_mode, e);
            }
        }

        public void setInput(EObject eObject) {
            this.setTitle(eObject.eClass().getName());
            this.setDescription(String.valueOf(EEFRuntimeUIMessages.PropertiesEditionWizard_main_page_description) + eObject.eClass().getName());
            EObjectPropertiesEditionContext subContext = new EObjectPropertiesEditionContext(PropertiesEditionWizard.this.editingContext, null, eObject, PropertiesEditionWizard.this.editingContext.getAdapterFactory());
            this.viewer.setInput(subContext);
            this.viewer.addPropertiesListener(this);
        }

        public void firePropertiesChanged(IPropertiesEditionEvent event) {
            this.handleChange(event);
        }

        private void handleChange(IPropertiesEditionEvent event) {
            if (this.viewer.isInitializing()) {
                return;
            }
            PropertiesEditionWizard.this.messageManager.processMessage(event);
        }

        private void updateStatus(String message) {
            this.setMessage(null);
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementCreationWizardPage
    extends WizardPage {
        private List<Button> buttons;
        private List<EClass> instanciableTypes;

        protected ElementCreationWizardPage() {
            super(EEFRuntimeUIMessages.PropertiesEditionWizard_creation_page_key);
            this.buttons = new ArrayList<Button>();
            this.instanciableTypes = null;
            this.setTitle(EEFRuntimeUIMessages.PropertiesEditionWizard_creation_page_title);
            this.setDescription(EEFRuntimeUIMessages.PropertiesEditionWizard_creation_page_description);
        }

        protected void setInstanciableTypes(List<EClass> instanciableTypes) {
            this.instanciableTypes = instanciableTypes;
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            control.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            control.setLayout((Layout)layout);
            if (this.instanciableTypes == null) {
                this.instanciableTypes = PropertiesEditionWizard.this.getInstanciableTypesInHierarchy();
            }
            for (final EClass eClass : this.instanciableTypes) {
                Button button = new Button(control, 16);
                button.setText(eClass.getName());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.editingContext instanceof EReferencePropertiesEditionContext && ((EReferencePropertiesEditionContext)((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.editingContext).getSettings() != null) {
                            EEFEditorSettings settings = ((EReferencePropertiesEditionContext)((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.editingContext).getSettings();
                            if (settings instanceof ReferencesTableSettings) {
                                ((ReferencesTableSettings)((EReferencePropertiesEditionContext)((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.editingContext).getSettings()).removeFromReference(((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.eObject);
                            }
                            ((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.eObject = EcoreUtil.create((EClass)eClass);
                            EEFUtils.putToReference(settings, ((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.eObject);
                        } else {
                            ((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.eObject = EcoreUtil.create((EClass)eClass);
                        }
                        ((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.mainPage.setInput(((ElementCreationWizardPage)ElementCreationWizardPage.this).PropertiesEditionWizard.this.eObject);
                    }
                });
                this.buttons.add(button);
            }
            if (this.buttons.size() > 0) {
                this.buttons.get(0).setSelection(true);
                PropertiesEditionWizard.this.eObject = EcoreUtil.create((EClass)this.instanciableTypes.get(0));
                if (PropertiesEditionWizard.this.editingContext instanceof EReferencePropertiesEditionContext && ((EReferencePropertiesEditionContext)PropertiesEditionWizard.this.editingContext).getSettings() != null) {
                    EEFUtils.putToReference(((EReferencePropertiesEditionContext)PropertiesEditionWizard.this.editingContext).getSettings(), PropertiesEditionWizard.this.eObject);
                }
            } else {
                Label errorLabel = new Label(control, 0);
                errorLabel.setText("Error non instanciable type found");
            }
            this.setControl((Control)control);
        }
    }
}

