/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.epp.internal.logging.aeri.ide.*;

import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;

import org.eclipse.jface.dialogs.Dialog;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class IdeFactoryImpl extends EFactoryImpl implements IIdeFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static IIdeFactory init() {
		try {
			IIdeFactory theIdeFactory = (IIdeFactory)EPackage.Registry.INSTANCE.getEFactory(IIdePackage.eNS_URI);
			if (theIdeFactory != null) {
				return theIdeFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new IdeFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdeFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case IIdePackage.LOG_EVENTS_QUEUE: return createLogEventsQueue();
			case IIdePackage.LOG_EVENT_GROUP: return createLogEventGroup();
			case IIdePackage.LOG_EVENT: return createLogEvent();
			case IIdePackage.INTERNAL_INPUT: return createInternalInput();
			case IIdePackage.SERVER_DESCRIPTOR: return createServerDescriptor();
			case IIdePackage.PROCESSOR_DESCRIPTOR: return createProcessorDescriptor();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case IIdePackage.IMAGE:
				return createImageFromString(eDataType, initialValue);
			case IIdePackage.DIALOG:
				return createDialogFromString(eDataType, initialValue);
			case IIdePackage.REPORT_PROCESSOR_SAFE_WRAPPER:
				return createReportProcessorSafeWrapperFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case IIdePackage.IMAGE:
				return convertImageToString(eDataType, instanceValue);
			case IIdePackage.DIALOG:
				return convertDialogToString(eDataType, instanceValue);
			case IIdePackage.REPORT_PROCESSOR_SAFE_WRAPPER:
				return convertReportProcessorSafeWrapperToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILogEventsQueue createLogEventsQueue() {
		LogEventsQueueImpl logEventsQueue = new LogEventsQueueImpl();
		return logEventsQueue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILogEventGroup createLogEventGroup() {
		LogEventGroupImpl logEventGroup = new LogEventGroupImpl();
		return logEventGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILogEvent createLogEvent() {
		LogEventImpl logEvent = new LogEventImpl();
		return logEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInternalInput createInternalInput() {
		InternalInputImpl internalInput = new InternalInputImpl();
		return internalInput;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IServerDescriptor createServerDescriptor() {
		ServerDescriptorImpl serverDescriptor = new ServerDescriptorImpl();
		return serverDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProcessorDescriptor createProcessorDescriptor() {
		ProcessorDescriptorImpl processorDescriptor = new ProcessorDescriptorImpl();
		return processorDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Image createImageFromString(EDataType eDataType, String initialValue) {
		return (Image)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertImageToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dialog createDialogFromString(EDataType eDataType, String initialValue) {
		return (Dialog)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDialogToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReportProcessorSafeWrapper createReportProcessorSafeWrapperFromString(EDataType eDataType, String initialValue) {
		return (ReportProcessorSafeWrapper)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertReportProcessorSafeWrapperToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IIdePackage getIdePackage() {
		return (IIdePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static IIdePackage getPackage() {
		return IIdePackage.eINSTANCE;
	}

} //IdeFactoryImpl
