package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.color.ColorPackage;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.ColorlistPackage;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.serializer.DotColorSemanticSequencer;
import org.eclipse.gef.dot.internal.language.services.DotColorListGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

@SuppressWarnings("all")
public class DotColorListSemanticSequencer extends DotColorSemanticSequencer {

	@Inject
	private DotColorListGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == ColorPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case ColorPackage.HSV_COLOR:
				if(context == grammarAccess.getColorRule() ||
				   context == grammarAccess.getHSVColorRule()) {
					sequence_HSVColor(context, (HSVColor) semanticObject); 
					return; 
				}
				else break;
			case ColorPackage.RGB_COLOR:
				if(context == grammarAccess.getColorRule() ||
				   context == grammarAccess.getRGBColorRule()) {
					sequence_RGBColor(context, (RGBColor) semanticObject); 
					return; 
				}
				else break;
			case ColorPackage.STRING_COLOR:
				if(context == grammarAccess.getColorRule() ||
				   context == grammarAccess.getStringColorRule()) {
					sequence_StringColor(context, (StringColor) semanticObject); 
					return; 
				}
				else break;
			}
		else if(semanticObject.eClass().getEPackage() == ColorlistPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case ColorlistPackage.COLOR_LIST:
				if(context == grammarAccess.getColorListRule()) {
					sequence_ColorList(context, (ColorList) semanticObject); 
					return; 
				}
				else break;
			case ColorlistPackage.WC:
				if(context == grammarAccess.getWCRule()) {
					sequence_WC(context, (WC) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (colorValues+=WC colorValues+=WC*)
	 */
	protected void sequence_ColorList(EObject context, ColorList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (color=Color weight=COLOR_NUMBER?)
	 */
	protected void sequence_WC(EObject context, WC semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
