/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.common.reflect.ReflectionUtils;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.DotRecordLabelStandaloneSetup;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsSubgraph;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotColorJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotRecordLabelJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotSubgrammarValidationMessageAcceptor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.RangeBasedDiagnostic;

public class DotJavaValidator
extends AbstractDotJavaValidator {
    public static final String INVALID_EDGE_OPERATOR = "invalid-edge-operator";
    public static final String REDUNDANT_ATTRIBUTE = "redundant-attribute";

    @Check
    public void checkValidAttributeValue(Attribute attribute) {
        String attributeName = attribute.getName().toValue();
        ID attributeValue = attribute.getValue();
        if (attributeValue == null) {
            return;
        }
        DotColorJavaValidator.considerDefaultColorScheme = true;
        DotColorJavaValidator.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue(attribute);
        List<Diagnostic> diagnostics = DotAttributes.validateAttributeRawValue(DotAttributes.getContext(attribute), attributeName, attributeValue);
        DotColorJavaValidator.globalColorScheme = null;
        DotColorJavaValidator.considerDefaultColorScheme = false;
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            System.err.println("Exact 1 node is expected for the attribute value: " + attributeValue + ", but got " + nodes.size());
            return;
        }
        INode node = (INode)nodes.get(0);
        int attributeValueStartOffset = node.getOffset();
        if (attributeValue.getType() == ID.Type.HTML_STRING || attributeValue.getType() == ID.Type.QUOTED_STRING) {
            ++attributeValueStartOffset;
        }
        for (Diagnostic d : diagnostics) {
            if (d instanceof RangeBasedDiagnostic) {
                RangeBasedDiagnostic rangeBasedDiagnostic = (RangeBasedDiagnostic)d;
                String message = rangeBasedDiagnostic.getMessage();
                int length = rangeBasedDiagnostic.getLength();
                String code = rangeBasedDiagnostic.getIssueCode();
                String[] issueData = rangeBasedDiagnostic.getIssueData();
                int offset = rangeBasedDiagnostic.getOffset() + attributeValueStartOffset;
                switch (d.getSeverity()) {
                    case 4: {
                        this.getMessageAcceptor().acceptError(message, (EObject)attribute, offset, length, code, issueData);
                        break;
                    }
                    case 2: {
                        this.getMessageAcceptor().acceptWarning(message, (EObject)attribute, offset, length, code, issueData);
                        break;
                    }
                    case 1: {
                        this.getMessageAcceptor().acceptInfo(message, (EObject)attribute, offset, length, code, issueData);
                    }
                }
                continue;
            }
            switch (d.getSeverity()) {
                case 4: {
                    this.getMessageAcceptor().acceptError(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attributeName, new String[]{attributeValue.toValue()});
                    break;
                }
                case 2: {
                    this.getMessageAcceptor().acceptWarning(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attributeName, new String[]{attributeValue.toValue()});
                    break;
                }
                case 1: {
                    this.getMessageAcceptor().acceptInfo(d.getMessage(), (EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, -1, attributeName, new String[]{attributeValue.toValue()});
                }
            }
        }
    }

    @Check
    public void checkValidCombinationOfNodeShapeAndStyle(Attribute attribute) {
        if (DotAttributes.getContext(attribute) == DotAttributes.Context.NODE && attribute.getName().toValue().equals("style") && attribute.getValue().toValue().equals(NodeStyle.STRIPED.toString())) {
            EList<AttrList> attributeList = null;
            NodeStmt node = (NodeStmt)EcoreUtil2.getContainerOfType((EObject)attribute, NodeStmt.class);
            if (node != null) {
                attributeList = node.getAttrLists();
            } else {
                AttrStmt attrStmt = (AttrStmt)EcoreUtil2.getContainerOfType((EObject)attribute, AttrStmt.class);
                if (attrStmt != null) {
                    attributeList = attrStmt.getAttrLists();
                }
            }
            if (attributeList != null) {
                ID shapeValue = DotAstHelper.getAttributeValue(attributeList, "shape");
                if (shapeValue == null) {
                    shapeValue = ID.fromString(PolygonBasedNodeShape.ELLIPSE.toString());
                }
                switch (PolygonBasedNodeShape.get(shapeValue.toValue())) {
                    case BOX: 
                    case RECT: 
                    case RECTANGLE: 
                    case SQUARE: {
                        break;
                    }
                    default: {
                        this.error("The style 'striped' is only supported with clusters and rectangularly-shaped nodes, such as 'box', 'rect', 'rectangle', 'square'.", (EStructuralFeature)DotPackage.eINSTANCE.getAttribute_Value());
                    }
                }
            }
        }
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsNode edgeRhsNode) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsNode.getOp(), ((DotGraph)EcoreUtil2.getContainerOfType((EObject)edgeRhsNode, DotGraph.class)).getType());
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsSubgraph edgeRhsSubgraph) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsSubgraph.getOp(), ((DotGraph)EcoreUtil2.getContainerOfType((EObject)edgeRhsSubgraph, DotGraph.class)).getType());
    }

    private void checkEdgeOpCorrespondsToGraphType(EdgeOp edgeOp, GraphType graphType) {
        boolean edgeDirected = edgeOp.equals((Object)EdgeOp.DIRECTED);
        boolean graphDirected = graphType.equals((Object)GraphType.DIGRAPH);
        if (graphDirected && !edgeDirected) {
            this.error("EdgeOp '--' may only be used in undirected graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op(), INVALID_EDGE_OPERATOR, new String[]{edgeOp.toString()});
        } else if (!graphDirected && edgeDirected) {
            this.error("EdgeOp '->' may only be used in directed graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op(), INVALID_EDGE_OPERATOR, new String[]{edgeOp.toString()});
        }
    }

    @Check
    public void checkRecordLabelValue(Attribute attribute) {
        String shapeValue;
        if (DotAttributes.getContext(attribute).equals((Object)DotAttributes.Context.NODE) && attribute.getName().toValue().equals("label") && RecordBasedNodeShape.get(shapeValue = DotAstHelper.getDependedOnAttributeValue(attribute, "shape")) != null && attribute.getValue().getType() != ID.Type.HTML_STRING) {
            this.doRecordLabelValidation(attribute);
        }
    }

    private void doRecordLabelValidation(Attribute attribute) {
        Injector recordLabelInjector = new DotRecordLabelStandaloneSetup().createInjectorAndDoEMFRegistration();
        DotRecordLabelJavaValidator validator = (DotRecordLabelJavaValidator)((Object)recordLabelInjector.getInstance(DotRecordLabelJavaValidator.class));
        IParser parser = (IParser)recordLabelInjector.getInstance(IParser.class);
        DotSubgrammarValidationMessageAcceptor messageAcceptor = new DotSubgrammarValidationMessageAcceptor(attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE, "record-based label", this.getMessageAcceptor(), "\"".length());
        validator.setMessageAcceptor(messageAcceptor);
        IParseResult result = parser.parse((Reader)new StringReader(attribute.getValue().toValue()));
        for (INode error : result.getSyntaxErrors()) {
            messageAcceptor.acceptSyntaxError(error);
        }
        HashMap<String, Object> validationContext = new HashMap<String, Object>();
        validationContext.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ReflectionUtils.getPrivateFieldValue((Object)((Object)validator), (String)"languageName"));
        TreeIterator iterator = result.getRootASTElement().eAllContents();
        while (iterator.hasNext()) {
            validator.validate((EObject)iterator.next(), null, validationContext);
        }
        validator.validate(result.getRootASTElement(), null, validationContext);
    }

    @Check
    public void checkRedundantAttribute(AttrList attrList) {
        HashSet<ID> definedAttributes = new HashSet<ID>();
        int i = attrList.getAttributes().size() - 1;
        while (i >= 0) {
            Attribute attribute = (Attribute)attrList.getAttributes().get(i);
            if (!definedAttributes.add(attribute.getName())) {
                this.warning("Redundant attribute value '" + attribute.getValue().toValue() + "' for attribute '" + attribute.getName() + "' is ignored.", attribute, null, REDUNDANT_ATTRIBUTE, new String[]{attribute.getName().toString()});
            }
            --i;
        }
    }
}

