/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.convert.swt;

import java.awt.geom.Path2D;
import org.eclipse.gef.geometry.convert.awt.AWT2Geometry;
import org.eclipse.gef.geometry.convert.swt.SWT2AWT;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Polygon;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SWT2Geometry {
    private static double[] toDoubles(int[] swtPointArray) {
        double[] pointArrayAsDoubles = new double[swtPointArray.length];
        int i = 0;
        while (i < swtPointArray.length) {
            pointArrayAsDoubles[i] = swtPointArray[i];
            ++i;
        }
        return pointArrayAsDoubles;
    }

    public static Object toLine(int ... swtPointArray) {
        if (swtPointArray == null || swtPointArray.length != 4) {
            throw new IllegalArgumentException("Cannot convert the given integer array to a GEF Line, because the integer array does not consist of exactly 4 coordinate values.");
        }
        return new Line((double)swtPointArray[0], (double)swtPointArray[1], (double)swtPointArray[2], (double)swtPointArray[3]);
    }

    public static Path toPath(int windingRule, PathData pd) {
        Path2D.Double path2d = new Path2D.Double();
        path2d.append(SWT2AWT.toAWTPathIterator(pd, windingRule), false);
        return AWT2Geometry.toPath((Path2D)path2d);
    }

    public static org.eclipse.gef.geometry.planar.Point toPoint(Point swtPoint) {
        return new org.eclipse.gef.geometry.planar.Point((double)swtPoint.x, (double)swtPoint.y);
    }

    public static Polygon toPolygon(int ... swtPointArray) {
        return new Polygon(SWT2Geometry.toDoubles(swtPointArray));
    }

    public static Object toPolyline(int ... swtPointArray) {
        return new Polyline(SWT2Geometry.toDoubles(swtPointArray));
    }

    public static org.eclipse.gef.geometry.planar.Rectangle toRectangle(Rectangle swtRectangle) {
        return new org.eclipse.gef.geometry.planar.Rectangle((double)swtRectangle.x, (double)swtRectangle.y, (double)swtRectangle.width, (double)swtRectangle.height);
    }

    private SWT2Geometry() {
    }
}

