/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Parent;
import javafx.scene.transform.Affine;
import javafx.scene.transform.TransformChangedEvent;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.domain.HistoricizingDomain;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.gestures.IGesture;
import org.eclipse.gef.mvc.fx.ui.MvcFxUiBundle;
import org.eclipse.gef.mvc.fx.ui.actions.FitToViewportAction;
import org.eclipse.swt.widgets.Event;

public class FitToViewportLockAction
extends FitToViewportAction {
    private ReadOnlyObjectProperty<Bounds> contentBoundsProperty;
    private Affine contentTransform;
    private InfiniteCanvas infiniteCanvas;
    private boolean needsExec = false;
    private EventHandler<TransformChangedEvent> trafoChangeListener = new EventHandler<TransformChangedEvent>(){

        public void handle(TransformChangedEvent event) {
            FitToViewportLockAction.this.setChecked(false);
        }
    };
    private ChangeListener<? super Bounds> contentBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            FitToViewportLockAction.this.needsExec = true;
            FitToViewportLockAction.this.onContentBoundsChanged();
        }
    };
    private ChangeListener<? super Number> scrollOffsetChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FitToViewportLockAction.this.setChecked(false);
        }
    };
    private ChangeListener<? super Number> sizeChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FitToViewportLockAction.this.needsExec = true;
            FitToViewportLockAction.this.onSizeChanged();
        }
    };
    private IOperationHistoryListener operationHistoryListener = ev -> {
        if (!this.needsExec) {
            return;
        }
        if (ev.getEventType() != 5 && ev.getEventType() != 8) {
            return;
        }
        this.needsExec = false;
        this.runIfEnabled();
    };

    public FitToViewportLockAction() {
        super("Fit-To-Viewport Lock", 2, MvcFxUiBundle.getDefault().getImageRegistry().getDescriptor("IMG_ICONS_FIT_TO_VIEWPORT_LOCK"));
    }

    protected void disableViewportListeners() {
        this.infiniteCanvas.horizontalScrollOffsetProperty().removeListener(this.scrollOffsetChangeListener);
        this.infiniteCanvas.verticalScrollOffsetProperty().removeListener(this.scrollOffsetChangeListener);
        this.contentTransform.removeEventHandler(TransformChangedEvent.TRANSFORM_CHANGED, this.trafoChangeListener);
        this.contentBoundsProperty.removeListener(this.contentBoundsChangeListener);
        this.infiniteCanvas.widthProperty().removeListener(this.sizeChangeListener);
        this.infiniteCanvas.heightProperty().removeListener(this.sizeChangeListener);
        IDomain domain = this.getViewer().getDomain();
        if (domain instanceof HistoricizingDomain) {
            IOperationHistory history = ((HistoricizingDomain)domain).getOperationHistory();
            history.removeOperationHistoryListener(this.operationHistoryListener);
        }
    }

    protected void enableViewportListeners() {
        this.infiniteCanvas.horizontalScrollOffsetProperty().addListener(this.scrollOffsetChangeListener);
        this.infiniteCanvas.verticalScrollOffsetProperty().addListener(this.scrollOffsetChangeListener);
        this.contentTransform.addEventHandler(TransformChangedEvent.TRANSFORM_CHANGED, this.trafoChangeListener);
        this.contentBoundsProperty.addListener(this.contentBoundsChangeListener);
        this.infiniteCanvas.widthProperty().addListener(this.sizeChangeListener);
        this.infiniteCanvas.heightProperty().addListener(this.sizeChangeListener);
        IDomain domain = this.getViewer().getDomain();
        if (domain instanceof HistoricizingDomain) {
            IOperationHistory history = ((HistoricizingDomain)domain).getOperationHistory();
            history.addOperationHistoryListener(this.operationHistoryListener);
        }
    }

    protected void lock() {
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            this.infiniteCanvas = (InfiniteCanvas)canvas;
            this.contentTransform = this.infiniteCanvas.getContentTransform();
            this.contentBoundsProperty = this.infiniteCanvas.contentBoundsProperty();
            this.enableViewportListeners();
        }
    }

    private void onContentBoundsChanged() {
        IDomain domain = this.getViewer().getDomain();
        Collection gestures = domain.getGestures().values();
        boolean isTransactionOpen = false;
        Iterator it = gestures.iterator();
        while (!isTransactionOpen && it.hasNext()) {
            IGesture gesture = (IGesture)it.next();
            isTransactionOpen = domain.isExecutionTransactionOpen(gesture);
        }
        if (!isTransactionOpen) {
            this.runIfEnabled();
        }
    }

    protected void onSizeChanged() {
        this.runIfEnabled();
    }

    @Override
    protected void register() {
        super.register();
        if (this.isChecked()) {
            this.lock();
            this.runWithEvent(null);
        }
    }

    protected void runIfEnabled() {
        if (this.isEnabled()) {
            this.runWithEvent(null);
        }
    }

    @Override
    public void runWithEvent(Event event) {
        this.needsExec = false;
        if (this.isChecked()) {
            this.disableViewportListeners();
            super.runWithEvent(event);
            this.enableViewportListeners();
        }
    }

    public void setChecked(boolean checked) {
        if (this.isEnabled()) {
            if (this.isChecked() && !checked) {
                this.unlock();
            } else if (!this.isChecked() && checked) {
                this.lock();
            }
        }
        super.setChecked(checked);
    }

    protected void unlock() {
        if (this.infiniteCanvas != null) {
            this.disableViewportListeners();
        }
    }

    @Override
    protected void unregister() {
        this.unlock();
        super.unregister();
    }
}

