/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.dnd.DelegatingDragAdapter;
import org.eclipse.gef.dnd.DelegatingDropAdapter;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractEditPartViewer
implements EditPartViewer {
    private DisposeListener disposeListener;
    private SelectionManager selectionModel;
    protected final List selection = new ArrayList();
    protected final List constantSelection = Collections.unmodifiableList(this.selection);
    protected List selectionListeners = new ArrayList(1);
    protected EditPart focusPart;
    private EditPartFactory factory;
    private Map mapIDToEditPart = new HashMap();
    private Map mapVisualToEditPart = new HashMap();
    private Map properties;
    private Control control;
    private ResourceManager resources;
    private EditDomain domain;
    private RootEditPart rootEditPart;
    private MenuManager contextMenu;
    private DragSource dragSource;
    private DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter();
    private DropTarget dropTarget;
    private DelegatingDropAdapter dropAdapter = new DelegatingDropAdapter();
    private KeyHandler keyHandler;
    private PropertyChangeSupport changeSupport;

    public AbstractEditPartViewer() {
        this.setSelectionManager(SelectionManager.createDefault());
        this.init();
    }

    public void setSelectionManager(SelectionManager model) {
        Assert.isNotNull((Object)model);
        if (this.selectionModel != null) {
            this.selectionModel.internalUninstall();
        }
        this.selectionModel = model;
        model.internalInitialize(this, this.selection, new Runnable(){

            public void run() {
                AbstractEditPartViewer.this.fireSelectionChanged();
            }
        });
        if (this.getControl() != null) {
            model.internalHookControl(this.getControl());
        }
    }

    public void addDragSourceListener(org.eclipse.gef.dnd.TransferDragSourceListener listener) {
        this.addDragSourceListener((TransferDragSourceListener)listener);
    }

    public void addDragSourceListener(TransferDragSourceListener listener) {
        this.getDelegatingDragAdapter().addDragSourceListener(listener);
        this.refreshDragSourceAdapter();
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        this.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)listener);
    }

    public void addDropTargetListener(org.eclipse.jface.util.TransferDropTargetListener listener) {
        this.getDelegatingDropAdapter().addDropTargetListener(listener);
        this.refreshDropTargetAdapter();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void appendSelection(EditPart editpart) {
        this.selectionModel.appendSelection(editpart);
    }

    public abstract Control createControl(Composite var1);

    public void deselect(EditPart editpart) {
        this.selectionModel.deselect(editpart);
    }

    public void deselectAll() {
        this.selectionModel.deselectAll();
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.resources != null) {
            this.resources.dispose();
        }
        this.setControl(null);
    }

    public final EditPart findObjectAt(Point pt) {
        return this.findObjectAtExcluding(pt, Collections.EMPTY_SET);
    }

    public final EditPart findObjectAtExcluding(Point pt, Collection exclude) {
        return this.findObjectAtExcluding(pt, exclude, null);
    }

    protected void fireSelectionChanged() {
        Object[] listeners = this.selectionListeners.toArray();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public void flush() {
    }

    public MenuManager getContextMenu() {
        return this.contextMenu;
    }

    public EditPart getContents() {
        return this.getRootEditPart().getContents();
    }

    public Control getControl() {
        return this.control;
    }

    protected DelegatingDragAdapter getDelegatingDragAdapter() {
        return this.dragAdapter;
    }

    protected DelegatingDropAdapter getDelegatingDropAdapter() {
        return this.dropAdapter;
    }

    protected DragSource getDragSource() {
        return this.dragSource;
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public EditDomain getEditDomain() {
        return this.domain;
    }

    public EditPartFactory getEditPartFactory() {
        return this.factory;
    }

    public Map getEditPartRegistry() {
        return this.mapIDToEditPart;
    }

    public EditPart getFocusEditPart() {
        if (this.focusPart != null) {
            return this.focusPart;
        }
        if (this.getSelectedEditParts().isEmpty()) {
            if (this.getContents() != null) {
                return this.getContents();
            }
            return this.getRootEditPart();
        }
        List selection = this.getSelectedEditParts();
        return (EditPart)selection.get(selection.size() - 1);
    }

    public KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public ResourceManager getResourceManager() {
        if (this.resources != null) {
            return this.resources;
        }
        Assert.isNotNull((Object)this.getControl());
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        return this.resources;
    }

    public RootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    public List getSelectedEditParts() {
        return this.constantSelection;
    }

    public ISelection getSelection() {
        return this.selectionModel.getSelection();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionModel;
    }

    public Map getVisualPartMap() {
        return this.mapVisualToEditPart;
    }

    protected void hookControl() {
        Control control = this.getControl();
        Assert.isTrue((control != null ? 1 : 0) != 0);
        this.getSelectionManager().internalHookControl(control);
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractEditPartViewer.this.handleDispose(e);
            }
        };
        control.addDisposeListener(this.disposeListener);
        if (this.getRootEditPart() != null) {
            this.getRootEditPart().activate();
        }
        this.refreshDragSourceAdapter();
        this.refreshDropTargetAdapter();
        if (this.contextMenu != null) {
            control.setMenu(this.contextMenu.createContextMenu(this.getControl()));
        }
    }

    protected void hookDragSource() {
        this.dragSource.addDragListener((DragSourceListener)this.getDelegatingDragAdapter());
    }

    protected void hookDropTarget() {
        this.getDropTarget().addDropListener((DropTargetListener)this.getDelegatingDropAdapter());
    }

    protected void init() {
    }

    private void primDeselectAll() {
        List list = this.primGetSelectedEditParts();
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            part.setSelected(0);
            ++i;
        }
        list.clear();
    }

    protected List primGetSelectedEditParts() {
        return this.selection;
    }

    protected void refreshDragSourceAdapter() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getDelegatingDragAdapter().isEmpty()) {
            this.setDragSource(null);
        } else {
            if (this.getDragSource() == null) {
                this.setDragSource(new DragSource(this.getControl(), 7));
            }
            this.getDragSource().setTransfer(this.getDelegatingDragAdapter().getTransfers());
        }
    }

    protected void refreshDropTargetAdapter() {
        if (this.getControl() == null) {
            return;
        }
        if (this.getDelegatingDropAdapter().isEmpty()) {
            this.setDropTarget(null);
        } else {
            if (this.getDropTarget() == null) {
                this.setDropTarget(new DropTarget(this.getControl(), 7));
            }
            this.getDropTarget().setTransfer(this.getDelegatingDropAdapter().getTransfers());
        }
    }

    public void registerAccessibleEditPart(AccessibleEditPart acc) {
    }

    public void removeDragSourceListener(org.eclipse.gef.dnd.TransferDragSourceListener listener) {
        this.removeDragSourceListener((TransferDragSourceListener)listener);
    }

    public void removeDragSourceListener(TransferDragSourceListener listener) {
        this.getDelegatingDragAdapter().removeDragSourceListener(listener);
        if (this.getDelegatingDragAdapter().isEmpty()) {
            this.refreshDragSourceAdapter();
        }
    }

    public void removeDropTargetListener(TransferDropTargetListener listener) {
        this.removeDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)listener);
    }

    public void removeDropTargetListener(org.eclipse.jface.util.TransferDropTargetListener listener) {
        this.getDelegatingDropAdapter().removeDropTargetListener(listener);
        if (this.getDelegatingDropAdapter().isEmpty()) {
            this.refreshDropTargetAdapter();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
            if (this.changeSupport.getPropertyChangeListeners().length == 0) {
                this.changeSupport = null;
            }
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.selectionListeners.remove(l);
    }

    public void reveal(EditPart part) {
    }

    public void select(EditPart editpart) {
        if (this.getSelectedEditParts().size() == 1 && this.getSelectedEditParts().get(0) == editpart) {
            return;
        }
        this.primDeselectAll();
        this.appendSelection(editpart);
    }

    public void setContextMenu(MenuManager manager) {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
        this.contextMenu = manager;
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setMenu(this.contextMenu.createContextMenu(this.getControl()));
        }
    }

    public void setContents(EditPart editpart) {
        this.getRootEditPart().setContents(editpart);
    }

    public void setContents(Object contents) {
        Assert.isTrue((this.getEditPartFactory() != null ? 1 : 0) != 0, (String)"An EditPartFactory is required to call setContents(Object)");
        this.setContents(this.getEditPartFactory().createEditPart(null, contents));
    }

    public void setControl(Control control) {
        if (this.control != null) {
            this.unhookControl();
        }
        this.control = control;
        if (control != null) {
            this.hookControl();
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.getControl().setCursor(cursor);
    }

    protected void setDragSource(DragSource source) {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = source;
        if (this.dragSource != null) {
            this.hookDragSource();
        }
    }

    protected void setDropTarget(DropTarget target) {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = target;
        if (this.dropTarget != null) {
            this.hookDropTarget();
        }
    }

    public void setEditDomain(EditDomain editdomain) {
        this.domain = editdomain;
    }

    public void setEditPartFactory(EditPartFactory factory) {
        this.factory = factory;
    }

    public void setFocus(EditPart part) {
        this.focusPart = part;
        this.getSelectionManager().setFocus(part);
    }

    public void setKeyHandler(KeyHandler handler) {
        this.keyHandler = handler;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        Object old = value == null ? this.properties.remove(key) : this.properties.put(key, value);
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(key, old, value);
        }
    }

    public void setRootEditPart(RootEditPart editpart) {
        if (this.rootEditPart != null) {
            if (this.rootEditPart.isActive()) {
                this.rootEditPart.deactivate();
            }
            this.rootEditPart.setViewer(null);
        }
        this.rootEditPart = editpart;
        this.rootEditPart.setViewer(this);
        if (this.getControl() != null) {
            this.rootEditPart.activate();
        }
    }

    public void setRouteEventsToEditDomain(boolean value) {
    }

    public void setSelection(ISelection newSelection) {
        this.selectionModel.setSelection(newSelection);
    }

    protected void unhookControl() {
        Assert.isTrue((this.getControl() != null ? 1 : 0) != 0);
        if (this.disposeListener != null) {
            this.getControl().removeDisposeListener(this.disposeListener);
            this.disposeListener = null;
        }
        if (this.getContextMenu() != null) {
            this.getContextMenu().dispose();
        }
        if (this.getRootEditPart() != null) {
            this.getRootEditPart().deactivate();
        }
    }

    public void unregisterAccessibleEditPart(AccessibleEditPart acc) {
    }
}

