/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.IMultiFixCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;

public abstract class AbstractMultiFixCore
extends AbstractCleanUpCore
implements IMultiFixCore {
    protected AbstractMultiFixCore() {
    }

    protected AbstractMultiFixCore(Map<String, String> settings) {
        super(settings);
    }

    @Override
    public final ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit unit = context.getAST();
        if (unit == null) {
            return null;
        }
        if (context instanceof IMultiFixCore.MultiFixContext) {
            return this.createFix(unit, ((IMultiFixCore.MultiFixContext)context).getProblemLocations());
        }
        return this.createFix(unit);
    }

    protected abstract ICleanUpFixCore createFix(CompilationUnit var1) throws CoreException;

    protected abstract ICleanUpFixCore createFix(CompilationUnit var1, IProblemLocationCore[] var2) throws CoreException;

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    protected static int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == problemId) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    protected static IProblemLocationCore[] convertProblems(IProblem[] problems) {
        IProblemLocationCore[] result = new IProblemLocationCore[problems.length];
        int i = 0;
        while (i < problems.length) {
            result[i] = new ProblemLocationCore(problems[i]);
            ++i;
        }
        return result;
    }

    protected static IProblemLocationCore[] filter(IProblemLocationCore[] problems, int[] problemIds) {
        ArrayList<IProblemLocationCore> result = new ArrayList<IProblemLocationCore>();
        int i = 0;
        while (i < problems.length) {
            IProblemLocationCore problem = problems[i];
            if (AbstractMultiFixCore.contains(problemIds, problem.getProblemId()) && !AbstractMultiFixCore.contains(result, problem)) {
                result.add(problem);
            }
            ++i;
        }
        return result.toArray(new IProblemLocationCore[result.size()]);
    }

    private static boolean contains(ArrayList<IProblemLocationCore> problems, IProblemLocationCore problem) {
        int i = 0;
        while (i < problems.size()) {
            IProblemLocationCore existing = problems.get(i);
            if (existing.getProblemId() == problem.getProblemId() && existing.getOffset() == problem.getOffset() && existing.getLength() == problem.getLength()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contains(int[] ids, int id) {
        int i = 0;
        while (i < ids.length) {
            if (ids[i] == id) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

