/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialTranslationExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.DeclaredLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class PotentialLiftExpression
extends PotentialTranslationExpression {
    private Expression teamExpr;
    public boolean requireReverseOperation = false;
    private Runnable liftingConfirmJob;
    private TypeReference expectedTypeReference = null;

    public void onLiftingRequired(Runnable job) {
        this.liftingConfirmJob = job;
    }

    public PotentialLiftExpression(Expression teamExpr, Expression expression, TypeBinding expectedType) {
        super(expression, expectedType);
        this.operator = "lift";
        this.teamExpr = teamExpr;
    }

    public PotentialLiftExpression(Expression teamExpr, Expression expression, TypeReference expectedTypeRef) {
        super(expression, null);
        this.expectedTypeReference = expectedTypeRef;
        this.operator = "lift";
        this.teamExpr = teamExpr;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        TypeBinding providedType = this.expression.resolveType(scope);
        if (providedType == null) {
            return null;
        }
        if (providedType.isParameterizedType()) {
            providedType = providedType.erasure();
        }
        if (this.expectedType == null) {
            this.expectedType = this.expectedTypeReference.resolvedType;
        }
        this.checked = true;
        return this.internalResolveType(scope, providedType, false);
    }

    private TypeBinding internalResolveType(BlockScope scope, TypeBinding providedType, boolean testOnly) {
        TypeBinding roleSideType;
        TypeBinding baseType;
        this.resolvedType = this.expectedType;
        TypeBinding compatibleType = this.compatibleType(scope, providedType);
        if (compatibleType != null) {
            return testOnly ? null : compatibleType;
        }
        if (providedType.isArrayType()) {
            if (!(this.expectedType instanceof ArrayBinding)) {
                throw new InternalCompilerError("mapping array to scalar");
            }
            baseType = providedType.leafComponentType();
            roleSideType = this.expectedType.leafComponentType();
        } else {
            baseType = providedType;
            roleSideType = this.expectedType;
        }
        ReferenceBinding roleType = null;
        if (!(baseType instanceof ReferenceBinding)) {
            return testOnly ? null : this.reportIncompatibility(scope, providedType);
        }
        roleType = (ReferenceBinding)roleSideType;
        if (!roleType.isDirectRole() || !(baseType instanceof ReferenceBinding)) {
            return testOnly ? null : this.reportIncompatibility(scope, providedType);
        }
        Config oldConfig = Config.createOrResetConfig(this);
        try {
            ReferenceBinding expectedBase = roleType.baseclass();
            if (expectedBase != null && expectedBase.isParameterizedType()) {
                expectedBase = (ReferenceBinding)expectedBase.erasure();
            }
            if (expectedBase == null || !baseType.isCompatibleWith(expectedBase)) {
                TypeBinding adjustedRole = TeamModel.getRoleToLiftTo(scope, baseType, roleType, true, this.expression);
                if (adjustedRole != null) {
                    this.expectedType = adjustedRole;
                } else {
                    ReferenceBinding roleBound;
                    if (providedType.isTypeVariable() && (roleBound = ((TypeVariableBinding)providedType).roletype) != null && roleBound.isRole()) {
                        this.generateDynamicLiftCall(scope, roleBound);
                        TypeBinding typeBinding = this.resolvedType;
                        return typeBinding;
                    }
                    scope.problemReporter().typeMismatchErrorPotentialLift(this.expression, providedType, this.expectedType, baseType);
                    this.resolvedType = null;
                    return null;
                }
            }
            if (roleType.isHierarchyInconsistent() || roleType.roleModel.hasBaseclassProblem()) {
                if (testOnly) {
                    return null;
                }
                scope.problemReporter().referenceContext.tagAsHavingErrors();
                TypeBinding typeBinding = this.resolvedType;
                return typeBinding;
            }
            if (Config.getLoweringRequired()) {
                throw new InternalCompilerError("Lifting would also require lowering!");
            }
        }
        finally {
            Config.removeOrRestore(oldConfig, this);
        }
        if (testOnly) {
            return this.expectedType;
        }
        TypeBinding expectedBaseclass = ((ReferenceBinding)this.expectedType.leafComponentType()).baseclass();
        if (this.expectedType.isArrayType()) {
            expectedBaseclass = new ArrayBinding(expectedBaseclass, this.expectedType.dimensions(), scope.environment());
        }
        this.checkOtherConversions(scope, expectedBaseclass, providedType);
        if (this.liftingConfirmJob != null) {
            this.liftingConfirmJob.run();
        }
        this.rawExpression = this.expression;
        this.operator = "lift";
        this.expression = this.genLiftCall(scope, providedType);
        return this.resolvedType;
    }

    private MessageSend genLiftCall(BlockScope scope, TypeBinding providedType) {
        MessageSend liftCall = Lifting.liftCall(scope, this.teamExpr, this.expression, providedType, this.expectedType, this.requireReverseOperation);
        liftCall.actualReceiverType = this.teamExpr.resolveType(scope);
        if (this.teamExpr.resolvedType instanceof ReferenceBinding) {
            liftCall.binding = ((ReferenceBinding)this.teamExpr.resolvedType).getMethod(scope, liftCall.selector);
        }
        if (liftCall.binding == null) {
            if (liftCall.actualReceiverType != null && TeamModel.hasRoFiCache((ReferenceBinding)liftCall.actualReceiverType)) {
                scope.problemReporter().unresolvedLifting(this, providedType, this.expectedType);
            } else {
                scope.problemReporter().referenceContext.tagAsHavingErrors();
            }
        }
        liftCall.constant = Constant.NotAConstant;
        liftCall.resolvedType = this.resolvedType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(this.expectedType, scope, (ASTNode)this);
        liftCall.argumentTypes = new TypeBinding[]{providedType};
        return liftCall;
    }

    private void generateDynamicLiftCall(BlockScope scope, ReferenceBinding roleType) {
        AstGenerator gen = new AstGenerator(this.expression);
        this.rawExpression = this.expression;
        Expression[] args = new Expression[]{this.expression};
        this.expression = gen.messageSend(this.teamExpr, DeclaredLifting.dynamicLiftSelector(roleType), args);
        this.resolvedType = this.expression.resolveType(scope);
    }

    public static boolean isLiftingRequired(BlockScope scope, TypeBinding requiredType, TypeBinding providedType, Expression location) {
        PotentialLiftExpression ple = new PotentialLiftExpression(null, location, requiredType);
        return ple.internalResolveType(scope, providedType, true) != null;
    }
}

