/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class RoleHierarchieAnalyzer {
    private ProblemReporter _problemReporter;
    private TypeDeclaration _teamTypeDeclaration;

    public RoleHierarchieAnalyzer(TypeDeclaration teamTypeDeclaration, ProblemReporter problemReporter) {
        this._teamTypeDeclaration = teamTypeDeclaration;
        this._problemReporter = problemReporter;
    }

    public RoleModel[] analyze(TreeNode role) {
        Set<RoleModel> relevantRoles = this.getRelevantRoles(role);
        this.checkInstantiability(relevantRoles);
        this.detectLiftingAmbiguity(relevantRoles);
        RoleModel[] resultArray = relevantRoles.toArray(new RoleModel[relevantRoles.size()]);
        role.getTreeObject().setSubRoles(resultArray);
        return resultArray;
    }

    private Set<RoleModel> getRelevantRoles(TreeNode role) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        TreeNode[] children = role.getChildren();
        RoleModel parent = role.getTreeObject();
        if (children == null) {
            if (!parent.hasBaseclassProblem()) {
                result.add(parent);
            }
            return result;
        }
        if (this.isRelevant(parent, children)) {
            result.add(parent);
        }
        int idx = 0;
        while (idx < children.length) {
            Set<RoleModel> relevantChildren = this.getRelevantRoles(children[idx]);
            if (!relevantChildren.isEmpty()) {
                result.addAll(relevantChildren);
            }
            ++idx;
        }
        return result;
    }

    public void checkInstantiability(Set<RoleModel> relevantRoles) {
        TeamModel teamModel = null;
        ArrayList<RoleModel> irrelevant = new ArrayList<RoleModel>();
        for (RoleModel role : relevantRoles) {
            if (teamModel == null) {
                teamModel = role.getTeamModel();
            }
            if (!role.getBinding().isAbstract()) continue;
            if (!teamModel.getBinding().isAbstract()) {
                if (role.getBinding().isPublic() && !role.getBinding().isInterface()) {
                    this._problemReporter.abstractRelevantRole(role, teamModel);
                } else if (role.getBaseTypeBinding().isAbstract()) {
                    this._problemReporter.abstractPotentiallyRelevantRole(role, teamModel);
                } else {
                    this._problemReporter.abstractRelevantRole(role, teamModel);
                }
            }
            irrelevant.add(role);
        }
        relevantRoles.removeAll(irrelevant);
    }

    private boolean isRelevant(RoleModel parent, TreeNode[] children) {
        ReferenceBinding parentBaseType = parent.getBaseTypeBinding();
        int idx = 0;
        while (idx < children.length) {
            RoleModel child = children[idx].getTreeObject();
            if (!child.hasBaseclassProblem() && TypeBinding.equalsEquals(child.getBaseTypeBinding(), parentBaseType)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private void detectLiftingAmbiguity(Set<RoleModel> roles) {
        ReferenceBinding[] commonSupers;
        if (roles == null || roles.isEmpty()) {
            return;
        }
        HashSet<RoleModel> rolesToAnalyze = new HashSet<RoleModel>();
        HashSet<RoleModel> ambiguitySet = new HashSet<RoleModel>();
        Iterator<RoleModel> iterator = roles.iterator();
        RoleModel role = iterator.next();
        ReferenceBinding baseBinding = role.getBaseTypeBinding();
        ambiguitySet.add(role);
        while (iterator.hasNext()) {
            RoleModel otherRole = iterator.next();
            ReferenceBinding otherBase = otherRole.getBaseTypeBinding();
            if (TypeBinding.equalsEquals(baseBinding, otherBase)) {
                ambiguitySet.add(otherRole);
                continue;
            }
            rolesToAnalyze.add(otherRole);
        }
        if (ambiguitySet.size() > 1 && (commonSupers = this.getCommonBoundSuperRoles(ambiguitySet.iterator())).length > 0) {
            this._problemReporter.potentiallyAmbiguousRoleBinding(this._teamTypeDeclaration, ambiguitySet);
            ReferenceBinding[] referenceBindingArray = commonSupers;
            int n = commonSupers.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding commonSuper = referenceBindingArray[n2];
                this._teamTypeDeclaration.getTeamModel().ambigousLifting.add(new Pair<ReferenceBinding, ReferenceBinding>(baseBinding, commonSuper));
                ++n2;
            }
            int i = 0;
            while (i < commonSupers.length) {
                commonSupers[i].roleModel._hasBindingAmbiguity = true;
                ++i;
            }
        }
        if (!rolesToAnalyze.isEmpty()) {
            this.detectLiftingAmbiguity(rolesToAnalyze);
        }
    }

    private ReferenceBinding[] getCommonBoundSuperRoles(Iterator<RoleModel> roles) {
        HashSet<ReferenceBinding> allBoundSupers = new HashSet<ReferenceBinding>();
        LinkedList<ReferenceBinding> commonBoundSupers = new LinkedList<ReferenceBinding>();
        while (roles.hasNext()) {
            RoleModel role = roles.next();
            ReferenceBinding currentRole = role.getBinding();
            while ((currentRole = currentRole.superclass()) != null && currentRole.isRole()) {
                if (currentRole.baseclass() == null) continue;
                if (allBoundSupers.contains(currentRole)) {
                    commonBoundSupers.add(currentRole);
                    continue;
                }
                allBoundSupers.add(currentRole);
            }
        }
        ReferenceBinding[] result = new ReferenceBinding[commonBoundSupers.size()];
        commonBoundSupers.toArray(result);
        return result;
    }
}

