/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(usage="usage_RebuildCommitGraph")
class RebuildCommitGraph
extends TextBuiltin {
    private static final String REALLY = "--destroy-this-repository";
    @Option(name="--destroy-this-repository", usage="usage_approveDestructionOfRepository")
    boolean really;
    @Argument(index=0, required=true, metaVar="metaVar_refs", usage="usage_forEachRefOutput")
    File refList;
    @Argument(index=1, required=true, metaVar="metaVar_refs", usage="usage_logAllPretty")
    File graph;
    private final ProgressMonitor pm;
    private Map<ObjectId, ObjectId> rewrites;

    RebuildCommitGraph() {
        this.pm = new TextProgressMonitor((Writer)this.errw);
        this.rewrites = new HashMap<ObjectId, ObjectId>();
    }

    @Override
    protected void run() throws Exception {
        if (!this.really && this.db.getRefDatabase().hasRefs()) {
            File directory = this.db.getDirectory();
            String absolutePath = directory == null ? "null" : directory.getAbsolutePath();
            this.errw.println(MessageFormat.format(CLIText.get().fatalThisProgramWillDestroyTheRepository, absolutePath, REALLY));
            throw RebuildCommitGraph.die(CLIText.get().needApprovalToDestroyCurrentRepository);
        }
        if (!this.refList.isFile()) {
            throw RebuildCommitGraph.die(MessageFormat.format(CLIText.get().noSuchFile, this.refList.getPath()));
        }
        if (!this.graph.isFile()) {
            throw RebuildCommitGraph.die(MessageFormat.format(CLIText.get().noSuchFile, this.graph.getPath()));
        }
        this.recreateCommitGraph();
        this.detachHead();
        this.deleteAllRefs();
        this.recreateRefs();
    }

    /*
     * Exception decompiling
     */
    private void recreateCommitGraph() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void detachHead() throws IOException {
        String head = this.db.getFullBranch();
        ObjectId id = this.db.resolve("HEAD");
        if (!ObjectId.isId((String)head) && id != null) {
            LockFile lf = new LockFile(new File(this.db.getDirectory(), "HEAD"));
            if (!lf.lock()) {
                throw new IOException(MessageFormat.format(CLIText.get().cannotLock, "HEAD"));
            }
            lf.write(id);
            if (!lf.commit()) {
                throw new IOException(CLIText.get().cannotDeatchHEAD);
            }
        }
    }

    private void deleteAllRefs() throws Exception {
        RevWalk rw = new RevWalk(this.db);
        for (Ref r : this.db.getRefDatabase().getRefs()) {
            if ("HEAD".equals(r.getName())) continue;
            RefUpdate u = this.db.updateRef(r.getName());
            u.setForceUpdate(true);
            u.delete(rw);
        }
    }

    private void recreateRefs() throws Exception {
        Map<String, Ref> refs = this.computeNewRefs();
        new RefWriter(refs.values()){

            protected void writeFile(String name, byte[] content) throws IOException {
                File file = new File(RebuildCommitGraph.this.db.getDirectory(), name);
                LockFile lck = new LockFile(file);
                if (!lck.lock()) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
            }
        }.writePackedRefs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Ref> computeNewRefs() throws IOException {
        HashMap<String, Ref> refs = new HashMap<String, Ref>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            RevWalk rw = new RevWalk(this.db);
            try {
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.refList), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        String[] parts = line.split("[ \t]{1,}");
                        ObjectId origId = ObjectId.fromString((String)parts[0]);
                        String type = parts[1];
                        String name = parts[2];
                        ObjectId id = this.rewrites.get(origId);
                        if (id == null) {
                            id = origId;
                        }
                        try {
                            rw.parseAny((AnyObjectId)id);
                        }
                        catch (MissingObjectException mue) {
                            if ("commit".equals(type)) throw new MissingObjectException(id, type);
                            this.errw.println(MessageFormat.format(CLIText.get().skippingObject, type, name));
                            continue;
                        }
                        refs.put(name, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id));
                    }
                }
                if (rw == null) return refs;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rw == null) throw throwable;
                rw.close();
                throw throwable;
            }
            rw.close();
            return refs;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static class ToRewrite {
        final ObjectId oldId;
        final long commitTime;
        final ObjectId[] oldParents;
        ObjectId newId;

        ToRewrite(ObjectId o, long t, ObjectId[] p) {
            this.oldId = o;
            this.commitTime = t;
            this.oldParents = p;
        }
    }
}

