/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;
import org.eclipse.jgit.transport.CredentialsProvider;

public class JGitClientSession
extends ClientSessionImpl {
    private static final int DEFAULT_MAX_IDENTIFICATION_SIZE = 65536;
    private HostConfigEntry hostConfig;
    private CredentialsProvider credentialsProvider;
    private volatile StatefulProxyConnector proxyHandler;

    public JGitClientSession(ClientFactoryManager manager, IoSession session) throws Exception {
        super(manager, session);
    }

    public HostConfigEntry getHostConfigEntry() {
        return this.hostConfig;
    }

    public void setHostConfigEntry(HostConfigEntry hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setProxyHandler(StatefulProxyConnector handler) {
        this.proxyHandler = handler;
    }

    protected IoWriteFuture sendIdentification(String ident) throws IOException {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            try {
                proxy.runWhenDone(() -> {
                    JGitClientSession.super.sendIdentification(ident);
                    return null;
                });
                return null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception other) {
                throw new IOException(other.getLocalizedMessage(), other);
            }
        }
        return super.sendIdentification(ident);
    }

    protected byte[] sendKexInit() throws IOException, GeneralSecurityException {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            try {
                proxy.runWhenDone(() -> {
                    JGitClientSession.super.sendKexInit();
                    return null;
                });
                return null;
            }
            catch (IOException | GeneralSecurityException e) {
                throw e;
            }
            catch (Exception other) {
                throw new IOException(other.getLocalizedMessage(), other);
            }
        }
        return super.sendKexInit();
    }

    public void messageReceived(Readable buffer) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.messageReceived(this.getIoSession(), buffer);
        } else {
            super.messageReceived(buffer);
        }
    }

    protected void checkKeys() throws SshException {
        PublicKey serverKey;
        SocketAddress remoteAddress;
        ServerKeyVerifier serverKeyVerifier = this.getServerKeyVerifier();
        if (!serverKeyVerifier.verifyServerKey((ClientSession)this, remoteAddress = this.getConnectAddress(), serverKey = this.getKex().getServerKey())) {
            throw new SshException(9, SshdText.get().kexServerKeyInvalid);
        }
    }

    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ServerKeyVerifier verifier;
        LinkedHashSet<String> defaultSignatures = new LinkedHashSet<String>();
        defaultSignatures.addAll(this.getSignatureFactoriesNames());
        HostConfigEntry config = (HostConfigEntry)this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String hostKeyAlgorithms = config.getProperty("HostKeyAlgorithms");
        if (hostKeyAlgorithms != null && !hostKeyAlgorithms.isEmpty()) {
            char first = hostKeyAlgorithms.charAt(0);
            if (first == '+') {
                return String.join((CharSequence)",", defaultSignatures);
            }
            if (first == '-') {
                this.removeFromList(defaultSignatures, "HostKeyAlgorithms", hostKeyAlgorithms.substring(1));
                if (defaultSignatures.isEmpty()) {
                    this.log.warn(MessageFormat.format(SshdText.get().configNoRemainingHostKeyAlgorithms, hostKeyAlgorithms));
                }
                return String.join((CharSequence)",", defaultSignatures);
            }
            List<String> newNames = this.filteredList(defaultSignatures, hostKeyAlgorithms);
            if (newNames.isEmpty()) {
                this.log.warn(MessageFormat.format(SshdText.get().configNoKnownHostKeyAlgorithms, hostKeyAlgorithms));
            } else {
                return String.join((CharSequence)",", newNames);
            }
        }
        if ((verifier = this.getServerKeyVerifier()) instanceof ServerKeyLookup) {
            SocketAddress remoteAddress = this.resolvePeerAddress((SocketAddress)this.resolveAttribute(JGitSshClient.ORIGINAL_REMOTE_ADDRESS));
            List<PublicKey> allKnownKeys = ((ServerKeyLookup)verifier).lookup((ClientSession)this, remoteAddress);
            LinkedHashSet<String> reordered = new LinkedHashSet<String>();
            for (PublicKey key : allKnownKeys) {
                String keyType;
                if (key == null || (keyType = KeyUtils.getKeyType((Key)key)) == null) continue;
                reordered.add(keyType);
            }
            reordered.addAll(defaultSignatures);
            return String.join((CharSequence)",", reordered);
        }
        return String.join((CharSequence)",", defaultSignatures);
    }

    private void removeFromList(Set<String> current, String key, String patterns) {
        String[] stringArray = patterns.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toRemove = stringArray[n2];
            if (toRemove.indexOf(42) < 0 && toRemove.indexOf(63) < 0) {
                current.remove(toRemove);
            } else {
                try {
                    FileNameMatcher matcher = new FileNameMatcher(toRemove, null);
                    Iterator<String> i = current.iterator();
                    while (i.hasNext()) {
                        matcher.reset();
                        matcher.append(i.next());
                        if (!matcher.isMatch()) continue;
                        i.remove();
                    }
                }
                catch (InvalidPatternException e) {
                    this.log.warn(MessageFormat.format(SshdText.get().configInvalidPattern, key, toRemove));
                }
            }
            ++n2;
        }
    }

    private List<String> filteredList(Set<String> known, String values) {
        ArrayList<String> newNames = new ArrayList<String>();
        String[] stringArray = values.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newValue = stringArray[n2];
            if (known.contains(newValue)) {
                newNames.add(newValue);
            }
            ++n2;
        }
        return newNames;
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        try {
            return super.readIdentification(buffer);
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    protected List<String> doReadIdentification(Buffer buffer, boolean server) {
        int end;
        if (server) {
            throw new IllegalStateException("doReadIdentification of client called with server=true");
        }
        int maxIdentSize = PropertyResolverUtils.getIntProperty((PropertyResolver)this, (String)"max-identification-size", (int)65536);
        int current = buffer.rpos();
        if (current >= (end = current + buffer.available())) {
            return null;
        }
        byte[] raw = buffer.array();
        ArrayList<String> ident = new ArrayList<String>();
        int start = current;
        boolean hasNul = false;
        int i = current;
        while (i < end) {
            switch (raw[i]) {
                case 0: {
                    hasNul = true;
                    break;
                }
                case 10: {
                    int eol = 1;
                    if (i > start && raw[i - 1] == 13) {
                        ++eol;
                    }
                    String line = new String(raw, start, i + 1 - eol - start, StandardCharsets.UTF_8);
                    start = i + 1;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.valueOf(MessageFormat.format("doReadIdentification({0}) line: ", new Object[]{this})) + JGitClientSession.escapeControls(line));
                    }
                    ident.add(line);
                    if (line.startsWith("SSH-")) {
                        if (hasNul) {
                            throw new IllegalStateException(MessageFormat.format(SshdText.get().serverIdWithNul, JGitClientSession.escapeControls(line)));
                        }
                        if (line.length() + eol > 255) {
                            throw new IllegalStateException(MessageFormat.format(SshdText.get().serverIdTooLong, JGitClientSession.escapeControls(line)));
                        }
                        buffer.rpos(start);
                        return ident;
                    }
                    hasNul = false;
                    break;
                }
            }
            if (i - current + 1 >= maxIdentSize) {
                String msg = MessageFormat.format(SshdText.get().serverIdNotReceived, Integer.toString(maxIdentSize));
                if (this.log.isDebugEnabled()) {
                    this.log.debug(msg);
                    this.log.debug(buffer.toHex());
                }
                throw new IllegalStateException(msg);
            }
            ++i;
        }
        return null;
    }

    private static String escapeControls(String s) {
        StringBuilder b = new StringBuilder();
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch)) {
                b.append(ch <= '\u000f' ? "\\u000" : "\\u00").append(Integer.toHexString(ch));
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }
}

