/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.commands.IStartAut;
import org.eclipse.jubula.autagent.common.monitoring.MonitoringDataStore;
import org.eclipse.jubula.autagent.common.monitoring.MonitoringUtil;
import org.eclipse.jubula.autagent.common.utils.AutStartHelperRegister;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartToolkitAut
implements IStartAut {
    private static Logger log = LoggerFactory.getLogger(AbstractStartToolkitAut.class);
    private static String developer = EnvironmentUtils.getProcessOrSystemProperty((String)"JubulaRCDeveloperMode");
    private StartAUTServerStateMessage m_errorMessage;
    private boolean m_isAgentSet = false;

    @Override
    public StartAUTServerStateMessage startAut(Map<String, String> parameters) throws IOException {
        StartAUTServerStateMessage envCheckMsg = this.validateEnvironment();
        AutIdentifier autId = new AutIdentifier(parameters.get("AUT_ID"));
        if (envCheckMsg == null) {
            if (!MonitoringUtil.checkForDuplicateAutID(String.valueOf(autId))) {
                MonitoringDataStore cm = MonitoringDataStore.getInstance();
                cm.putConfigMap(autId.getID(), parameters);
            }
            File workingDir = this.getWorkingDir(parameters);
            String java = this.createBaseCmd(parameters);
            String[] cmdArray = this.createCmdArray(java, parameters);
            String[] envArray = this.createEnvArray(parameters, this.m_isAgentSet);
            if (envArray == null && log.isInfoEnabled()) {
                log.info("envArray: NULL");
            }
            if (log.isInfoEnabled()) {
                StringBuffer logMessage = new StringBuffer();
                int i = 0;
                while (i < cmdArray.length) {
                    logMessage.append(String.valueOf(cmdArray[i]) + " ");
                    ++i;
                }
                log.info("starting AUT with command: " + logMessage.toString());
            }
            StartAUTServerStateMessage stateMessage = this.executeCommand(cmdArray, envArray, workingDir, autId);
            stateMessage.setAutId(autId);
            return stateMessage;
        }
        envCheckMsg.setAutId(autId);
        return envCheckMsg;
    }

    protected StartAUTServerStateMessage validateEnvironment() {
        return null;
    }

    protected File getWorkingDir(Map parameters) {
        File workingDir;
        String autWorkDir = (String)parameters.get("WORKING_DIR");
        if (autWorkDir == null) {
            autWorkDir = "";
        }
        if (!(workingDir = new File(autWorkDir)).isDirectory() || !workingDir.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Working dir: invalid");
            }
            workingDir = null;
        }
        return workingDir;
    }

    protected String[] createEnvArray(Map<String, String> parameters, boolean isAgentSet) {
        this.m_isAgentSet = isAgentSet;
        String environment = parameters.get("ENVIRONMENT");
        boolean generate = Boolean.valueOf(parameters.get("NAME_TECHNICAL_COMPONENTS"));
        Properties oldProp = EnvironmentUtils.getProcessEnvironment();
        String[] newEnvArray = null;
        if (generate) {
            Properties generateProperty = new Properties();
            generateProperty.setProperty("TEST_GENERATE_NAMES_PROPERTY", String.valueOf(generate));
            oldProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)generateProperty);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)oldProp, (String)"=");
        }
        if (environment != null && environment.trim().length() != 0) {
            String[] envArray = EnvironmentUtils.strToStrArray((String)environment, (String)"\r\n");
            Properties newProp = EnvironmentUtils.strArrayToProp((String[])envArray, (String)"=");
            newProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)newProp);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)newProp, (String)"=");
        }
        return newEnvArray;
    }

    protected abstract String createBaseCmd(Map<String, String> var1) throws IOException;

    protected abstract String[] createCmdArray(String var1, Map<String, String> var2);

    protected StartAUTServerStateMessage executeCommand(String[] cmdArray, String[] envArray, File workingDir, AutIdentifier autId) throws IOException {
        AutStarter autAgent = AutStarter.getInstance();
        Process process = Runtime.getRuntime().exec(cmdArray, envArray, workingDir);
        if (this.isErrorMessage()) {
            log.error("AbstractStartToolkitAut - executeCommand: " + this.getErrorMessage());
            return this.getErrorMessage();
        }
        if (!autAgent.watchAUT(process, this.m_isAgentSet, autId)) {
            process.destroy();
            return this.createBusyMessage();
        }
        return new StartAUTServerStateMessage(0);
    }

    protected void setErrorMessage(StartAUTServerStateMessage errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected StartAUTServerStateMessage getErrorMessage() {
        if (this.m_errorMessage == null) {
            this.m_errorMessage = new StartAUTServerStateMessage(1, "Unexpected error, no detail available.");
        }
        return this.m_errorMessage;
    }

    protected boolean isErrorMessage() {
        return this.m_errorMessage != null;
    }

    protected StartAUTServerStateMessage createBusyMessage() {
        return new StartAUTServerStateMessage(1, "AUTServer is already running");
    }

    private static String[] getClasspathEntriesForBundleId(String bundleId) {
        IAUTStartHelper helper = AutStartHelperRegister.INSTANCE.getAutStartHelper();
        if (helper == null) {
            log.error("No AUTStartHelper registered ");
            throw new IllegalStateException("No AUTStartHelper registered");
        }
        return helper.getClasspathEntriesForBundleId(bundleId);
    }

    public static String getClasspathForBundleId(String bundleId) {
        String[] classPath = AbstractStartToolkitAut.getClasspathEntriesForBundleId(bundleId);
        return AbstractStartToolkitAut.createClassPath(classPath);
    }

    protected static String createClassPath(String[] classPath) {
        StringBuilder pathBuilder = new StringBuilder();
        String[] stringArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String jarless = AbstractStartToolkitAut.convertToDirectories(entry);
            if (jarless == null) {
                pathBuilder.append(entry).append(PATH_SEPARATOR);
            } else {
                pathBuilder.append(jarless);
            }
            ++n2;
        }
        return pathBuilder.length() == 0 ? "" : pathBuilder.substring(0, pathBuilder.lastIndexOf(PATH_SEPARATOR));
    }

    private static String convertToDirectories(String entry) {
        String jubulaBeginning;
        int lastIndex;
        String withoutJar;
        String toTest;
        if (developer == null) {
            return null;
        }
        if (entry.contains("target") && !entry.contains("agent") && entry.endsWith(".jar") && (toTest = (withoutJar = entry).substring(lastIndex = withoutJar.lastIndexOf("/"), withoutJar.length())).contains(jubulaBeginning = "org.eclipse.jubula")) {
            withoutJar = withoutJar.substring(0, lastIndex + 1);
            withoutJar = withoutJar.replace("/target/", "/bin/");
            return String.valueOf(withoutJar) + PATH_SEPARATOR;
        }
        return null;
    }

    protected void addDebugParams(List<String> cmds, boolean isDirectExec) {
        String rcDebug = IStartAut.RC_DEBUG;
        if (rcDebug != null) {
            if (isDirectExec) {
                cmds.add("-vmargs -Xms128m -Xmx512m");
            }
            cmds.add("-Xdebug");
            cmds.add("-Xnoagent");
            cmds.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + rcDebug);
            cmds.add("-Djava.compiler=NONE");
        }
    }

    public abstract String getRcBundleId();
}

