/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.gui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jubula.tools.internal.constants.InputCodeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentOMKeyProperitesUtils {
    public static final Properties KEY_PROPERTIES = new Properties();
    private static final String INPUT_TYPE = "INPUT_TYPE";
    private static final String INPUT = "INPUT";
    private static final String MODIFIER = "MODIFIER";
    private static final String PROPERTIES_PATH = String.valueOf(System.getProperty("user.home")) + "/.jubula/OMagent.props";
    private static final Logger LOG = LoggerFactory.getLogger(AgentOMKeyProperitesUtils.class);

    static {
        AgentOMKeyProperitesUtils.loadPropertiesFromFile();
    }

    private AgentOMKeyProperitesUtils() {
    }

    public static void loadPropertiesFromFile() {
        File file = new File(PROPERTIES_PATH);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    KEY_PROPERTIES.load(inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error("Exception during reading of properties", (Throwable)e);
            }
        }
    }

    public static void writePropertiesToFile() {
        File file = new File(PROPERTIES_PATH);
        if (!file.exists() && !file.isDirectory() && file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException ie) {
                LOG.error("Except during creation of File", (Throwable)ie);
                return;
            }
        }
        try {
            Throwable ie = null;
            Object var2_5 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                KEY_PROPERTIES.store(outputStream, "objectMappingKeys");
            }
            catch (Throwable throwable) {
                if (ie == null) {
                    ie = throwable;
                } else if (ie != throwable) {
                    ie.addSuppressed(throwable);
                }
                throw ie;
            }
        }
        catch (IOException ie) {
            LOG.error("Exception during writing of OM keys", (Throwable)ie);
        }
    }

    public static int getModifier() {
        try {
            return Integer.parseInt(KEY_PROPERTIES.getProperty(MODIFIER));
        }
        catch (Exception exception) {
            return 192;
        }
    }

    public static InputCodeHelper.UserInput getInput() {
        try {
            int keyCode = Integer.parseInt(KEY_PROPERTIES.getProperty(INPUT));
            int keyType = Integer.parseInt(KEY_PROPERTIES.getProperty(INPUT_TYPE));
            return new InputCodeHelper.UserInput(keyCode, keyType);
        }
        catch (Exception exception) {
            return new InputCodeHelper.UserInput(81, 1);
        }
    }

    public static void setModifier(int modifier) {
        KEY_PROPERTIES.setProperty(MODIFIER, Integer.toString(modifier));
    }

    public static void setInput(InputCodeHelper.UserInput input) {
        KEY_PROPERTIES.setProperty(INPUT, Integer.toString(input.getCode()));
        KEY_PROPERTIES.setProperty(INPUT_TYPE, Integer.toString(input.getType()));
    }
}

