/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.jubula.autagent.common.commands.IStartAut;
import org.eclipse.jubula.autagent.common.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.common.monitoring.MonitoringDataStore;
import org.eclipse.jubula.autagent.common.monitoring.MonitoringUtil;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;
import org.eclipse.jubula.tools.internal.utils.ZipUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiAUTStartHelper
implements IAUTStartHelper {
    private static final String SOURCE_BUNDLE_MANIFEST_ATTR = "Eclipse-SourceBundle";
    private static final Logger LOG = LoggerFactory.getLogger(OsgiAUTStartHelper.class);

    public File getInstallationDirectory() {
        Location installLoc = Platform.getInstallLocation();
        String installDir = installLoc.getURL().getFile();
        return new File(installDir);
    }

    public String getMonitoringAgent(Map<String, String> parameters) {
        Bundle bundle;
        String monitoringImplClass;
        String agentString;
        boolean duplicate;
        MonitoringDataStore mds;
        String autId;
        block12: {
            autId = parameters.get("AUT_ID");
            mds = MonitoringDataStore.getInstance();
            duplicate = MonitoringUtil.checkForDuplicateAutID((String)autId);
            if (!duplicate) {
                mds.putConfigMap(autId, parameters);
            }
            agentString = null;
            monitoringImplClass = parameters.get("AGENT_CLASS");
            String bundleId = parameters.get("BUNDLE_ID");
            bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) break block12;
            LOG.error("No bundle was found for the given bundleId");
            return null;
        }
        try {
            Class monitoringClass = bundle.loadClass(monitoringImplClass);
            Constructor constructor = monitoringClass.getConstructor(new Class[0]);
            IMonitoring agentInstance = (IMonitoring)constructor.newInstance(new Object[0]);
            agentInstance.setAutId(autId);
            agentInstance.setInstallDir(FileLocator.getBundleFile((Bundle)bundle));
            agentString = agentInstance.createAgent();
            if (!duplicate) {
                mds.putMonitoringAgent(autId, agentInstance);
            }
        }
        catch (InstantiationException e) {
            LOG.error("The instantiation of the monitoring class failed ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Access to the monitoring class failed ", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error("Access to the monitoring class failed ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("A method in the monitoring class could not be found", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("A argument which is passed to monitoring class is invalide", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("The method call of 'getAgent' failed, you have to implement the interface IMonitoring", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("The monitoring class can not be found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException while searching for the given bundle", (Throwable)e);
        }
        return agentString;
    }

    public String[] getClasspathEntriesForBundleId(String bundleId) {
        Bundle mainBundle = OsgiAUTStartHelper.getBundleForID(bundleId);
        if (mainBundle == null) {
            return new String[0];
        }
        ArrayList<Bundle> bundleAndFragmentList = new ArrayList<Bundle>();
        bundleAndFragmentList.add(mainBundle);
        if (StringUtils.containsIgnoreCase((String)bundleId, (String)"jubula") || StringUtils.containsIgnoreCase((String)bundleId, (String)"guidancer")) {
            bundleAndFragmentList.addAll(OsgiAUTStartHelper.getFragmentsForBundleId(bundleId));
        }
        ArrayList<String> classpathEntries = new ArrayList<String>();
        for (Bundle bundle : bundleAndFragmentList) {
            classpathEntries.addAll(OsgiAUTStartHelper.getPathforBundle(bundle));
        }
        return classpathEntries.toArray(new String[classpathEntries.size()]);
    }

    public static Bundle getBundleForID(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null && (bundle = OsgiAUTStartHelper.bundleLookupWithInactive(bundleId)) == null) {
            LOG.error("No bundle found for ID '" + bundleId + "'.");
        }
        return bundle;
    }

    public static List<Bundle> getFragmentsForBundleId(String rcBundleId) {
        Bundle fragmentHost = OsgiAUTStartHelper.getBundleForID(rcBundleId);
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        Bundle[] f = Platform.getFragments((Bundle)fragmentHost);
        if (f == null) {
            fragments.addAll(OsgiAUTStartHelper.fragmentLookupWithInactive(fragmentHost));
        } else {
            Bundle[] bundleArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                fragments.add(fragment);
                ++n2;
            }
        }
        return fragments;
    }

    public static List<String> getPathforBundle(Bundle bundle) {
        ArrayList<String> path;
        block8: {
            path = new ArrayList<String>();
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                if (bundleFile.isFile()) {
                    path.add(bundleFile.getAbsolutePath());
                    try {
                        File[] createdFiles = ZipUtil.unzipTempJars((File)bundleFile);
                        int i = 0;
                        while (i < createdFiles.length) {
                            path.add(createdFiles[i].getAbsolutePath());
                            ++i;
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        LOG.error("An error occurred while trying to extract nested JARs from " + bundle.getSymbolicName(), (Throwable)e);
                    }
                    break block8;
                }
                Enumeration e = bundle.findEntries("/", "*.jar", true);
                if (e != null) {
                    while (e.hasMoreElements()) {
                        URL jarUrl = (URL)e.nextElement();
                        File jarFile = new File(bundleFile + jarUrl.getFile());
                        if (OsgiAUTStartHelper.isJarFileWithManifestAttr(jarFile, SOURCE_BUNDLE_MANIFEST_ATTR)) continue;
                        path.add(jarFile.getAbsolutePath());
                    }
                }
            }
            catch (IOException ioe) {
                LOG.error("Bundle with ID '" + bundle.getSymbolicName() + "' could not be resolved to a file.", (Throwable)ioe);
            }
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJarFileWithManifestAttr(File file, String manifestAttr) {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) return false;
                boolean bl = manifest.getMainAttributes().containsKey(new Attributes.Name(manifestAttr));
                return bl;
            }
            catch (IOException ioe) {
                LOG.error("Error while reading JAR file.", (Throwable)ioe);
                return false;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    LOG.error("Error while closing JAR file.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            LOG.error("Error while opening JAR file.", (Throwable)ioe);
            return false;
        }
        catch (SecurityException se) {
            LOG.error("Error while opening JAR file.", (Throwable)se);
        }
        return false;
    }

    private static List<Bundle> fragmentLookupWithInactive(Bundle mainBundle) {
        Bundle[] bundles = EclipseStarter.getSystemBundleContext().getBundles();
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String fragmentHost = (String)bundle.getHeaders().get("Fragment-Host");
            if (fragmentHost != null) {
                if (fragmentHost.contains(";")) {
                    fragmentHost = fragmentHost.split(";")[0];
                }
                if (fragmentHost.equals(mainBundle.getSymbolicName())) {
                    for (Bundle fragment : fragments) {
                        if (!fragment.getSymbolicName().equals(bundle.getSymbolicName()) || bundle.getVersion().compareTo(fragment.getVersion()) <= 0) continue;
                        fragments.remove(fragment);
                    }
                    fragments.add(bundle);
                }
            }
            ++n2;
        }
        return fragments;
    }

    private static Bundle bundleLookupWithInactive(String bundleId) {
        BundleContext systemBundleContext = EclipseStarter.getSystemBundleContext();
        Bundle result = null;
        if (systemBundleContext != null) {
            Bundle[] bundles = systemBundleContext.getBundles();
            Version currVersion = Version.emptyVersion;
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().equals(bundleId) && bundle.getVersion().compareTo(currVersion) > 0) {
                    result = bundle;
                    currVersion = bundle.getVersion();
                }
                ++n2;
            }
        } else {
            LOG.warn("systemBundleContext is null - skipping bundleLookupWithInactive()");
        }
        return result;
    }

    public Map<String, String> getFragmentPathforBundleID(String rcBundleID) {
        HashMap<String, String> fragmentMap = new HashMap<String, String>();
        List<Object> fragments = new ArrayList();
        fragments = OsgiAUTStartHelper.getFragmentsForBundleId(rcBundleID);
        for (Bundle bundle : fragments) {
            StringBuilder pathBuilder = new StringBuilder();
            for (String entry : OsgiAUTStartHelper.getPathforBundle(bundle)) {
                pathBuilder.append(entry).append(IStartAut.PATH_SEPARATOR);
            }
            if (pathBuilder.length() <= 0) continue;
            fragmentMap.put(pathBuilder.substring(0, pathBuilder.lastIndexOf(IStartAut.PATH_SEPARATOR)), (String)bundle.getHeaders().get("Bundle-Name"));
        }
        return fragmentMap;
    }
}

