/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.Date;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class TestResultEditorInput
implements IEditorInput {
    private Long m_testResultSumaryId;
    private String m_testSuiteName;
    private Date m_testSuiteStartTime;
    private Date m_testSuiteEndTime;

    public TestResultEditorInput(ITestResultSummaryPO testResultSummary) {
        Validate.notNull((Object)testResultSummary);
        this.m_testResultSumaryId = testResultSummary.getId();
        this.m_testSuiteName = testResultSummary.getTestsuiteName();
        this.m_testSuiteStartTime = testResultSummary.getTestsuiteStartTime();
        this.m_testSuiteEndTime = testResultSummary.getTestsuiteEndTime();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return this.m_testSuiteName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.m_testSuiteName).append(" ").append("(").append(this.m_testSuiteStartTime).append(")");
        return msg.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TestResultEditorInput.class) {
            return this;
        }
        return null;
    }

    public Long getTestResultSummaryId() {
        return this.m_testResultSumaryId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestResultEditorInput)) {
            return false;
        }
        TestResultEditorInput otherInput = (TestResultEditorInput)obj;
        return new EqualsBuilder().append((Object)this.getToolTipText(), (Object)otherInput.getToolTipText()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getToolTipText()).toHashCode();
    }

    public Date getTestSuiteEndTime() {
        return this.m_testSuiteEndTime;
    }
}

