/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.we.editors.properties.tabbedPage;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.we.editors.properties.tabbedPage.PropertyPropertySection;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.properties.tabbedPage.TabbedModelPropertySheetPage;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTabbedPropertySheetPage
extends TabbedModelPropertySheetPage {
    private static final int DYNPROP_SECTION_HEIGHT = 115;
    private static final String DYNPROP_TAB_DESCRIPTOR_ID = "org.eclipse.jwt.we.propertytabs.aspects.Property";
    private TabContents propertyTab;

    public PropertyTabbedPropertySheetPage(WEEditor editor) {
        super(editor);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ListenerList selectionChangedListeners = null;
        try {
            Field field = Viewer.class.getDeclaredField("selectionChangedListeners");
            field.setAccessible(true);
            selectionChangedListeners = (ListenerList)field.get(this.getTabbedPropertyViewer());
            Object[] listeners = selectionChangedListeners.getListeners();
            ISelectionChangedListener superListener = (ISelectionChangedListener)listeners[0];
            listeners[0] = new MySelectionChangedListener(superListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        boolean doRefresh = true;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("currentTab");
            field.setAccessible(true);
            TabContents myCurrentTab = (TabContents)field.get((Object)this);
            if (myCurrentTab == null) {
                doRefresh = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doRefresh) {
            super.refresh();
        }
    }

    protected TabContents createTab(ITabDescriptor tabDescriptor) {
        TabContents myTab = tabDescriptor.createTab();
        if (this.isDynamicPropertyTab(tabDescriptor)) {
            this.propertyTab = myTab;
        }
        return myTab;
    }

    private boolean isDynamicPropertyTab(ITabDescriptor tabDescriptor) {
        if (tabDescriptor == null) {
            return false;
        }
        return DYNPROP_TAB_DESCRIPTOR_ID.equals(tabDescriptor.getId());
    }

    private Composite createMyTabComposite() {
        TabbedPropertyComposite myTabbedPropertyComposite = (TabbedPropertyComposite)this.getControl();
        Composite result = this.getWidgetFactory().createComposite(myTabbedPropertyComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        boolean myHasTitleBar = true;
        data.top = myHasTitleBar ? new FormAttachment((Control)myTabbedPropertyComposite.getTitle(), 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection.equals(this.getCurrentSelection())) {
            return;
        }
        this.setCurrentSelection(selection);
        ISelection myCurrentSelection = this.getCurrentSelection();
        try {
            Method m = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredMethod("validateRegistry", ISelection.class);
            m.setAccessible(true);
            m.invoke((Object)this, selection);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ITabDescriptor[] descriptors = this.getRegistry().getTabDescriptors(part, myCurrentSelection);
        if (descriptors.length > 0) {
            this.updateTabs(descriptors);
        }
        TabbedPropertyViewer myTabbedPropertyViewer = this.getTabbedPropertyViewer();
        myTabbedPropertyViewer.setInput(part, myCurrentSelection);
        int lastTabSelectionIndex = 0;
        try {
            Method m = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredMethod("getLastTabSelection", IWorkbenchPart.class, ISelection.class);
            m.setAccessible(true);
            lastTabSelectionIndex = (Integer)m.invoke((Object)this, part, myCurrentSelection);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Object selectedTab = myTabbedPropertyViewer.getElementAt(lastTabSelectionIndex);
        if (this.isDynamicPropertyTab((ITabDescriptor)selectedTab) && this.propertyTab != null) {
            EObject modelElement = this.jwtSpecificGetAspectsFromSelection(myCurrentSelection);
            List aspects = AspectManager.INSTANCE.getAspectInstances(modelElement);
            Composite tabComposite = this.reCreateAndInitDynamicPropertyTab(aspects.size());
            Composite tabCompositeParent = tabComposite.getParent();
            tabCompositeParent.pack(true);
            tabComposite.setVisible(true);
            this.setTabInput(part, aspects);
        }
        this.setSelectionQueueLocked(true);
        try {
            if (selectedTab == null) {
                myTabbedPropertyViewer.setSelection(null);
            } else {
                myTabbedPropertyViewer.setSelection((ISelection)new StructuredSelection(selectedTab));
            }
        }
        finally {
            this.setSelectionQueueLocked(false);
        }
        try {
            Method m = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredMethod("refreshTitleBar", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Composite reCreateAndInitDynamicPropertyTab(int sectionNb) {
        Composite tabComposite = (Composite)this.getTabToComposite().get(this.propertyTab);
        if (tabComposite != null) {
            tabComposite.dispose();
        }
        ArrayList<PropertyPropertySection> sections = new ArrayList<PropertyPropertySection>(sectionNb);
        int i = 0;
        while (i < sectionNb) {
            PropertyPropertySection propSect = new PropertyPropertySection();
            sections.add(propSect);
            ++i;
        }
        this.propertyTab.setSections(sections.toArray(new ISection[sections.size()]));
        tabComposite = this.createMyTabComposite();
        this.propertyTab.createControls(tabComposite, (TabbedPropertySheetPage)this);
        this.getTabToComposite().put(this.propertyTab, tabComposite);
        return tabComposite;
    }

    private void setTabInput(IWorkbenchPart part, List<AspectInstance> aspects) {
        int i = 0;
        while (i < this.propertyTab.getSections().length) {
            ISection section = this.propertyTab.getSections()[i];
            if (i < aspects.size()) {
                AspectInstance aspect = aspects.get(i);
                section.setInput(part, (ISelection)new StructuredSelection((Object)aspect));
            }
            ++i;
        }
    }

    private EObject getSelectedEObject(Object selectionOrElement) {
        if (selectionOrElement instanceof IStructuredSelection) {
            selectionOrElement = ((IStructuredSelection)selectionOrElement).getFirstElement();
        }
        if (selectionOrElement instanceof EObject) {
            return (EObject)selectionOrElement;
        }
        return null;
    }

    private EObject jwtSpecificGetAspectsFromSelection(Object selectionOrElement) {
        EObject selectedElement = this.getSelectedEObject(selectionOrElement);
        if (selectedElement != null && selectedElement instanceof Reference) {
            return ((Reference)selectedElement).getReference();
        }
        return selectedElement;
    }

    public void resizeScrolledComposite() {
        ScrollBar horizontalScrollBar;
        Composite sizeReference;
        if (this.getCurrentTab() != this.propertyTab) {
            super.resizeScrolledComposite();
            return;
        }
        Point currentTabSize = new Point(0, 0);
        if (this.propertyTab != null && (sizeReference = (Composite)this.getTabToComposite().get(this.propertyTab)) != null) {
            currentTabSize = sizeReference.computeSize(-1, -1);
            currentTabSize = new Point(currentTabSize.x, this.propertyTab.getSections().length * 115);
        }
        TabbedPropertyComposite tabbedPropertyComposite = (TabbedPropertyComposite)this.getControl();
        tabbedPropertyComposite.getScrolledComposite().setMinSize(currentTabSize);
        ScrollBar verticalScrollBar = tabbedPropertyComposite.getScrolledComposite().getVerticalBar();
        if (verticalScrollBar != null) {
            Rectangle clientArea = tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.height - 5;
            verticalScrollBar.setPageIncrement(increment);
        }
        if ((horizontalScrollBar = tabbedPropertyComposite.getScrolledComposite().getHorizontalBar()) != null) {
            Rectangle clientArea = tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.width - 5;
            horizontalScrollBar.setPageIncrement(increment);
        }
    }

    private Map getTabToComposite() {
        Map myTabToComposite = null;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("tabToComposite");
            field.setAccessible(true);
            myTabToComposite = (Map)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myTabToComposite;
    }

    private Map getDescriptorToTab() {
        Map descriptorToTab = null;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("descriptorToTab");
            field.setAccessible(true);
            descriptorToTab = (Map)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return descriptorToTab;
    }

    protected ISelection getCurrentSelection() {
        ISelection myCurrentSelection = null;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("currentSelection");
            field.setAccessible(true);
            myCurrentSelection = (ISelection)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myCurrentSelection;
    }

    private void setCurrentSelection(ISelection currentSelection) {
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("currentSelection");
            field.setAccessible(true);
            field.set((Object)this, currentSelection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TabbedPropertyViewer getTabbedPropertyViewer() {
        TabbedPropertyViewer myTabbedPropertyViewer = null;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("tabbedPropertyViewer");
            field.setAccessible(true);
            myTabbedPropertyViewer = (TabbedPropertyViewer)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myTabbedPropertyViewer;
    }

    private TabbedPropertyRegistry getRegistry() {
        TabbedPropertyRegistry myRegistry = null;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("registry");
            field.setAccessible(true);
            myRegistry = (TabbedPropertyRegistry)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myRegistry;
    }

    private boolean getSelectionQueueLocked() {
        boolean mySelectionQueueLocked = false;
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("selectionQueueLocked");
            field.setAccessible(true);
            mySelectionQueueLocked = (Boolean)field.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mySelectionQueueLocked;
    }

    private void setSelectionQueueLocked(boolean selectionQueueLocked) {
        try {
            Field field = TabbedPropertySheetPage.class.getDeclaredField("selectionQueueLocked");
            field.setAccessible(true);
            field.set((Object)this, selectionQueueLocked);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MySelectionChangedListener
    implements ISelectionChangedListener {
        private ISelectionChangedListener superSelectionChangedListener;

        public MySelectionChangedListener(ISelectionChangedListener superSelectionChangedListener) {
            this.superSelectionChangedListener = superSelectionChangedListener;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            ITabDescriptor descriptor = (ITabDescriptor)selection.getFirstElement();
            if (PropertyTabbedPropertySheetPage.this.isDynamicPropertyTab(descriptor)) {
                TabbedPropertyViewer myTabbedPropertyViewer = PropertyTabbedPropertySheetPage.this.getTabbedPropertyViewer();
                EObject modelElement = PropertyTabbedPropertySheetPage.this.jwtSpecificGetAspectsFromSelection(myTabbedPropertyViewer.getInput());
                List aspects = AspectManager.INSTANCE.getAspectInstances(modelElement);
                Composite tabComposite = PropertyTabbedPropertySheetPage.this.reCreateAndInitDynamicPropertyTab(aspects.size());
                this.superSelectionChangedListener.selectionChanged(event);
                Composite tabCompositeParent = tabComposite.getParent();
                tabCompositeParent.pack(true);
                tabComposite.setVisible(true);
                PropertyTabbedPropertySheetPage.this.setTabInput(PropertyTabbedPropertySheetPage.this.getTabbedPropertyViewer().getWorkbenchPart(), aspects);
            } else {
                this.superSelectionChangedListener.selectionChanged(event);
            }
        }
    }
}

