/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.doc.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.organisations.Role;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.external.WEExternalAction;
import org.eclipse.jwt.we.editors.pages.activityEditor.WEEditorSheet;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.SaveImage;
import org.eclipse.jwt.we.plugins.doc.Activator;
import org.eclipse.jwt.we.plugins.doc.HtmlDocumentation;
import org.eclipse.jwt.we.plugins.doc.Messages;
import org.eclipse.jwt.we.plugins.doc.actions.CaseInsensitiveComparator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class DocAction
extends WEExternalAction {
    protected Model model = null;
    protected List packages = new ArrayList();
    protected List roles = new ArrayList();
    protected List data = new ArrayList();
    protected List applications = new ArrayList();
    protected List processes = new ArrayList();

    public ImageDescriptor getImage() {
        return Activator.getImageDescriptor("icons/documentation.gif");
    }

    public void run() {
        this.packages.clear();
        this.roles.clear();
        this.applications.clear();
        this.data.clear();
        this.processes.clear();
        String filepath = "";
        URL stylefullpath = null;
        String result = null;
        String[] filterExtensions = new String[]{"*.html"};
        boolean fileDoesExist = false;
        FileDialog filedialog = new FileDialog(GeneralHelper.getActiveShell(), 8192);
        filedialog.setFilterExtensions(filterExtensions);
        do {
            if ((filepath = filedialog.open()) == null || !new File(filepath).exists()) continue;
            boolean bl = fileDoesExist = !MessageDialog.openQuestion((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.dialog_overwrite_title, (String)PluginProperties.dialog_overwrite_message);
        } while (filepath != null && fileDoesExist);
        if (filepath != null) {
            Path path = new Path(filepath);
            if (path.getFileExtension() == null) {
                path = path.addFileExtension("html");
            }
            String finalpath = null;
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            if (preferenceStore.contains("csspathPreference")) {
                finalpath = Activator.getDefault().getPreferenceStore().getString("csspathPreference");
            } else {
                try {
                    File testfile;
                    Activator defaultplugin = Activator.getDefault();
                    Bundle bundle = defaultplugin.getBundle();
                    URL stylepath = bundle.getEntry("");
                    if (stylepath != null) {
                        stylefullpath = FileLocator.resolve((URL)stylepath);
                        if (stylefullpath.getProtocol().equals("jar")) {
                            finalpath = stylefullpath.getFile();
                            if ((finalpath = finalpath.substring(0, finalpath.length() - 2)).startsWith("file")) {
                                finalpath = finalpath.substring(5);
                            }
                        } else {
                            finalpath = String.valueOf(stylefullpath.getPath()) + "styles/style.css";
                        }
                    }
                    if (finalpath.startsWith("/")) {
                        finalpath = finalpath.substring(1);
                    }
                    if (!(testfile = new File(finalpath)).exists()) {
                        finalpath = null;
                    }
                }
                catch (Exception exception) {}
            }
            if (finalpath != null) {
                Object resource = this.getActiveResource().getContents().get(0);
                if (resource instanceof Model) {
                    this.model = (Model)resource;
                    EList firstlevel = this.model.getElements();
                    for (Object obj : firstlevel) {
                        if (obj instanceof Role) {
                            this.roles.add((Role)obj);
                            continue;
                        }
                        if (obj instanceof Application) {
                            this.applications.add((Application)obj);
                            continue;
                        }
                        if (obj instanceof Data) {
                            this.data.add((Data)obj);
                            continue;
                        }
                        if (!(obj instanceof Activity)) continue;
                        this.processes.add((Activity)obj);
                    }
                    EList firstpackages = this.model.getSubpackages();
                    Iterator i = firstpackages.iterator();
                    while (i.hasNext()) {
                        this.searchPackage((Package)i.next());
                    }
                    CaseInsensitiveComparator comparator = new CaseInsensitiveComparator();
                    Collections.sort(this.roles, comparator);
                    Collections.sort(this.applications, comparator);
                    Collections.sort(this.data, comparator);
                    Collections.sort(this.processes, comparator);
                    HtmlDocumentation template = new HtmlDocumentation();
                    result = template.generate(new Object[]{resource, this.roles, this.applications, this.data, this.processes});
                    File htmlfile = path.toFile();
                    try {
                        htmlfile.createNewFile();
                        FileOutputStream ostream = new FileOutputStream(htmlfile);
                        ostream.write(result.getBytes());
                        ostream.close();
                    }
                    catch (Exception exception) {}
                    File oldstylefile = null;
                    Path newstylepath = new Path(filepath);
                    newstylepath = newstylepath.removeLastSegments(1);
                    newstylepath = newstylepath.append("style.css");
                    File newstylefile = newstylepath.toFile();
                    if (stylefullpath.getProtocol().equals("file")) {
                        Path originalstylepath = new Path(finalpath);
                        oldstylefile = originalstylepath.toFile();
                        try {
                            int c;
                            FileReader filereader = new FileReader(oldstylefile);
                            FileWriter filewriter = new FileWriter(newstylefile);
                            newstylefile.createNewFile();
                            while ((c = filereader.read()) != -1) {
                                filewriter.write(c);
                            }
                            filereader.close();
                            filewriter.close();
                        }
                        catch (Exception exception) {}
                    } else if (stylefullpath.getProtocol().equals("jar")) {
                        try {
                            int c;
                            JarFile jarfile = new JarFile(finalpath);
                            JarEntry jarentry = jarfile.getJarEntry("styles/style.css");
                            InputStream inputstream = jarfile.getInputStream(jarentry);
                            InputStreamReader isreader = new InputStreamReader(inputstream);
                            FileWriter filewriter = new FileWriter(newstylefile);
                            newstylefile.createNewFile();
                            while ((c = isreader.read()) != -1) {
                                filewriter.write(c);
                            }
                            inputstream.close();
                            isreader.close();
                            filewriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        int counter = 0;
                        WEEditor editor = GeneralHelper.getActiveInstance();
                        Path imagehelppath = new Path(filepath);
                        imagehelppath = imagehelppath.removeLastSegments(1);
                        imagehelppath = imagehelppath.append("process");
                        String imagepath = imagehelppath.toPortableString();
                        int oldPageID = editor.getActivePage();
                        Iterator i2 = this.processes.iterator();
                        while (i2.hasNext()) {
                            ++counter;
                            Activity activity = (Activity)i2.next();
                            if (editor.activateIfAlreadyOpen(activity)) {
                                GraphicalViewer viewer = editor.getCurrentActivitySheet().getGraphicalViewer();
                                SaveImage.save((GraphicalViewer)viewer, (String)(String.valueOf(imagepath) + counter + ".jpg"), (int)4);
                                continue;
                            }
                            WEEditorSheet editorSheet = new WEEditorSheet(editor);
                            int pageID = editor.addPage((IEditorPart)editorSheet, editor.getEditorInput());
                            GraphicalViewer viewer = editorSheet.getGraphicalViewer();
                            editorSheet.loadActivityModel(activity);
                            editor.activatePage(pageID);
                            SaveImage.save((GraphicalViewer)viewer, (String)(String.valueOf(imagepath) + counter + ".jpg"), (int)4);
                            editor.removeActivityFromPage(activity);
                        }
                        editor.activatePage(oldPageID);
                    }
                    catch (Exception exception) {}
                }
            } else {
                MessageDialog dialog = new MessageDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell(), Messages.doc_dialog_title, null, Messages.doc_dialog_message, 2, new String[]{"OK"}, 0);
                dialog.create();
                dialog.open();
            }
        }
    }

    private void searchPackage(Package pack) {
        EList elements = pack.getElements();
        for (Object obj : elements) {
            if (obj instanceof Role) {
                this.roles.add((Role)obj);
                continue;
            }
            if (obj instanceof Application) {
                this.applications.add((Application)obj);
                continue;
            }
            if (obj instanceof Data) {
                this.data.add((Data)obj);
                continue;
            }
            if (!(obj instanceof Activity)) continue;
            this.processes.add((Activity)obj);
        }
        EList packages = pack.getSubpackages();
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            this.searchPackage((Package)i.next());
        }
    }
}

