/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.we.commands.view.CreateReferenceEdgeCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

public class ReconnectReferenceEdgeCommand
extends org.eclipse.gef.commands.Command {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private Reference newReference;
    private Action newAction;
    private Command removeOldRefEdgeCommand;
    private CreateReferenceEdgeCommand createNewRefEdgeCommand;
    private ReferenceEdge oldEdge;
    private boolean referenceChanged = false;
    private boolean actionChanged = false;

    public ReconnectReferenceEdgeCommand(WEEditor weeditor, EditingDomain editingDomain, ReferenceEdge oldEdge) {
        this.editingDomain = editingDomain;
        this.oldEdge = oldEdge;
        this.weeditor = weeditor;
    }

    public void setNewReference(Reference reference) {
        this.newReference = reference;
        if (reference != null && reference != this.getOldReference()) {
            this.referenceChanged = true;
        }
    }

    public void setNewAction(Action action) {
        this.newAction = action;
        if (action != null && action != this.getOldAction()) {
            this.actionChanged = true;
        }
    }

    private Reference getOldReference() {
        return this.oldEdge.getReference();
    }

    private Action getOldAction() {
        return this.oldEdge.getAction();
    }

    private Reference getNewReference() {
        return this.newReference;
    }

    private Action getNewAction() {
        return this.newAction;
    }

    public boolean checkConnection() {
        if (!this.referenceChanged && !this.actionChanged) {
            return false;
        }
        if (this.referenceChanged && this.actionChanged) {
            return false;
        }
        if (this.getOldReference().getReference() instanceof Data || this.getNewReference() != null && this.getNewReference().getReference() instanceof Data) {
            return false;
        }
        Action action = this.actionChanged ? this.getNewAction() : this.getOldAction();
        Reference reference = this.referenceChanged ? this.getNewReference() : this.getOldReference();
        for (ReferenceEdge refEdge : reference.getReferenceEdges()) {
            if (!refEdge.getAction().equals(action) || !refEdge.getReference().equals(reference)) continue;
            return false;
        }
        return true;
    }

    public boolean canExecute() {
        if (this.editingDomain == null) {
            return false;
        }
        return this.checkConnection();
    }

    public void execute() {
        this.removeOldRefEdgeCommand = null;
        this.createNewRefEdgeCommand = null;
        this.removeOldRefEdgeCommand = DeleteCommand.create((EditingDomain)this.editingDomain, Collections.singleton(this.oldEdge));
        Action action = this.actionChanged ? this.getNewAction() : this.getOldAction();
        Reference reference = this.referenceChanged ? this.getNewReference() : this.getOldReference();
        this.createNewRefEdgeCommand = new CreateReferenceEdgeCommand(this.weeditor, this.editingDomain);
        this.createNewRefEdgeCommand.setSource(action);
        this.createNewRefEdgeCommand.setTarget(reference);
        this.createNewRefEdgeCommand.setDirection(0);
        if (this.removeOldRefEdgeCommand.canExecute() && this.createNewRefEdgeCommand.canExecute()) {
            this.removeOldRefEdgeCommand.execute();
            this.createNewRefEdgeCommand.execute();
        }
    }

    public void undo() {
        this.createNewRefEdgeCommand.undo();
        this.removeOldRefEdgeCommand.undo();
    }

    public void redo() {
        this.removeOldRefEdgeCommand.redo();
        this.createNewRefEdgeCommand.redo();
    }

    public void dispose() {
        super.dispose();
        if (this.removeOldRefEdgeCommand != null) {
            this.removeOldRefEdgeCommand.dispose();
        }
        if (this.createNewRefEdgeCommand != null) {
            this.createNewRefEdgeCommand.dispose();
        }
    }
}

