/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.outline;

import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.factories.EcoreCopyFactory;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class TemplateTransferDragSourceListener
implements TransferDragSourceListener {
    private WEEditor weeditor;
    private ISelectionProvider dragSource;

    public TemplateTransferDragSourceListener(WEEditor weeditor, ISelectionProvider dragSource) {
        assert (dragSource != null);
        this.dragSource = dragSource;
        this.weeditor = weeditor;
    }

    private Object getTemplate() {
        ISelection selection = this.dragSource.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return new EcoreCopyFactory(this.weeditor, structuredSelection.toList());
        }
        return null;
    }

    public Transfer getTransfer() {
        return TemplateTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        Object template = this.getTemplate();
        if (template == null) {
            event.doit = false;
        }
        TemplateTransfer.getInstance().setTemplate(template);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getTemplate();
    }

    public void dragFinished(DragSourceEvent event) {
        TemplateTransfer.getInstance().setTemplate(null);
    }
}

