/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.core;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.parts.core.GraphicalModelElementEditPart;

public class GraphicalElementEditPartHelper
extends AdapterImpl
implements EditPartListener {
    private final EditPart editPart;

    public GraphicalElementEditPartHelper(EditPart editPart) {
        this.editPart = editPart;
        editPart.addEditPartListener((EditPartListener)this);
    }

    public GraphicalElement getModel() {
        return (GraphicalElement)this.editPart.getModel();
    }

    private void addNotify(Notifier notifier) {
        if (notifier != null) {
            notifier.eAdapters().add((Object)this);
        }
    }

    private void removeNotify(Notifier notifier) {
        if (notifier != null) {
            notifier.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof LayoutData) {
            int featureId = notification.getFeatureID(LayoutData.class);
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    switch (featureId) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.refreshVisuals();
                        }
                    }
                }
            }
        }
        if (notification.getNotifier() instanceof Diagram && notification.getFeatureID(Diagram.class) == 1) {
            this.refreshVisuals();
        }
    }

    public void partActivated(EditPart editpart) {
        this.addNotify((Notifier)this.getModel());
    }

    public void partDeactivated(EditPart editpart) {
        this.removeNotify((Notifier)this.getModel());
    }

    public void refreshVisuals() {
        if (!(this.editPart instanceof GraphicalEditPart)) {
            return;
        }
        IFigure figure = ((GraphicalEditPart)this.editPart).getFigure();
        WEEditor weeditor = ((GraphicalModelElementEditPart)this.editPart).getWEEditor();
        Rectangle figureBounds = new Rectangle(LayoutDataManager.getX(weeditor, this.getModel()), LayoutDataManager.getY(weeditor, this.getModel()), -1, -1);
        figure.setMinimumSize(new Dimension(LayoutDataManager.getWidth(weeditor, this.getModel()), LayoutDataManager.getHeight(weeditor, this.getModel())));
        if (this.editPart.getParent() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.editPart.getParent()).setLayoutConstraint(this.editPart, figure, (Object)figureBounds);
        }
    }

    public void removingChild(EditPart child, int index) {
    }

    public void childAdded(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
    }
}

