/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.Guard;
import org.eclipse.jwt.we.figures.processes.ActivityEdgeFigure;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.core.EdgeModelElementEditPart;
import org.eclipse.jwt.we.parts.processes.policies.ActivityEdgeEditPolicy;

public class ActivityEdgeEditPart
extends EdgeModelElementEditPart {
    Logger logger = Logger.getLogger(ActivityEdgeEditPart.class);

    public Class getModelClass() {
        return ActivityEdge.class;
    }

    public ActivityEdge getActivityEdge() {
        return (ActivityEdge)this.getModel();
    }

    protected List getModelChildren() {
        ArrayList<Guard> mylist = new ArrayList<Guard>();
        if (this.getActivityEdge().getGuard() != null) {
            mylist.add(this.getActivityEdge().getGuard());
        }
        return mylist;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ActivityEdgeEditPolicy());
    }

    public IFigure getContentPane() {
        return ((ActivityEdgeFigure)this.getFigure()).getContentPane();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        int featureId = notification.getFeatureID(ActivityEdge.class);
        int eventtype = notification.getEventType();
        switch (eventtype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (featureId) {
                    case 3: {
                        this.refreshChildren();
                    }
                }
            }
        }
    }
}

