/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal;

import java.net.URI;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;

public class LuaFunctionType
extends AtomicScriptType {
    public LuaFunctionType() {
        super("function (Lua)");
    }

    public String formatDetails(IScriptValue value) {
        return value.getRawValue();
    }

    public String formatValue(IScriptValue value) {
        return value.getRawValue().split("\\r?\\n")[0];
    }

    public FunctionData getData(IScriptValue value) {
        return new FunctionData(value);
    }

    public static final class FunctionData {
        private final String repr;
        private final URI path;
        private final int line;

        private FunctionData(IScriptValue value) {
            String[] lines = value.getRawValue().split("\\r?\\n");
            this.repr = lines[0];
            this.path = URI.create(lines[1]);
            this.line = Integer.valueOf(lines[2]);
        }

        public int getLine() {
            return this.line;
        }

        public URI getPath() {
            return this.path;
        }

        public String getRepr() {
            return this.repr;
        }
    }
}

