/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.actions;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.LineComparator;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PrepareCommitHandler
extends ChangeLogAction
implements IHandler {
    public Object execute(ExecutionEvent event) {
        IRunnableWithProgress code = monitor -> this.loadClipboard(monitor);
        ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            pd.run(false, false, code);
        }
        catch (InvocationTargetException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
        return null;
    }

    private void loadClipboard(IProgressMonitor monitor) {
        String diffResult;
        block27: {
            int kind;
            IEditorPart currentEditor;
            try {
                currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
            catch (Exception e) {
                return;
            }
            if (currentEditor == null) {
                return;
            }
            IFile changelog = this.getChangelogFile(this.getDocumentLocation(currentEditor, false));
            if (changelog == null) {
                return;
            }
            diffResult = "";
            IProject project = null;
            IResource[] resources = new IResource[]{changelog};
            project = changelog.getProject();
            RepositoryProvider r = RepositoryProvider.getProvider((IProject)project);
            if (r == null) {
                return;
            }
            SyncInfoSet set = new SyncInfoSet();
            Subscriber s = r.getSubscriber();
            try {
                s.refresh(resources, 0, monitor);
            }
            catch (TeamException teamException) {
                // empty catch block
            }
            s.collectOutOfSync(resources, 0, set, monitor);
            SyncInfo[] infos = set.getSyncInfos();
            if (infos.length == 1 && (kind = SyncInfo.getChange((int)infos[0].getKind())) == 3) {
                try {
                    IDiff d = s.getDiff(infos[0].getLocal());
                    if (!(d instanceof IThreeWayDiff) || ((IThreeWayDiff)d).getDirection() != 256) break block27;
                    IThreeWayDiff diff = (IThreeWayDiff)d;
                    monitor.beginTask(null, 100);
                    IResourceDiff localDiff = (IResourceDiff)diff.getLocalChange();
                    IFile file = (IFile)localDiff.getResource();
                    monitor.subTask(Messages.getString("ChangeLog.MergingDiffs"));
                    String osEncoding = file.getCharset();
                    IFileRevision ancestorState = localDiff.getBeforeState();
                    if (ancestorState == null) {
                        Object ancestorStorage = null;
                        return;
                    }
                    IStorage ancestorStorage = ancestorState.getStorage(monitor);
                    try {
                        LineComparator left = new LineComparator(ancestorStorage.getContents(), osEncoding);
                        LineComparator right = new LineComparator(file.getContents(), osEncoding);
                        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences((IRangeComparator)left, (IRangeComparator)right);
                        int n = rangeDifferenceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RangeDifference tmp = rangeDifferenceArray[n2];
                            if (tmp.kind() == 2) {
                                String line;
                                LineNumberReader l = new LineNumberReader(new InputStreamReader(file.getContents()));
                                int rightLength = tmp.rightLength() > 0 ? tmp.rightLength() : tmp.rightLength() + 1;
                                String line0 = null;
                                String preDiffResult = "";
                                int i = 0;
                                while (i < tmp.rightStart()) {
                                    try {
                                        line = l.readLine();
                                        if (line0 == null) {
                                            line0 = line;
                                        }
                                        preDiffResult = String.valueOf(preDiffResult) + line + "\n";
                                    }
                                    catch (IOException e) {
                                        break;
                                    }
                                    ++i;
                                }
                                i = 0;
                                while (i < rightLength) {
                                    try {
                                        line = l.readLine();
                                        if (i == rightLength - tmp.rightStart()) {
                                            if (tmp.rightStart() != 0 && line.equals(line0)) {
                                                diffResult = preDiffResult = String.valueOf(preDiffResult) + diffResult;
                                                i = rightLength;
                                            } else {
                                                diffResult = String.valueOf(diffResult) + line + "\n";
                                            }
                                        } else {
                                            diffResult = String.valueOf(diffResult) + line + "\n";
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    ++i;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    monitor.done();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        if (!diffResult.equals("")) {
            this.populateClipboardBuffer(diffResult);
        }
    }

    private void populateClipboardBuffer(String input) {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents((Object[])new String[]{input}, new Transfer[]{plainTextTransfer});
        clipboard.dispose();
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

