/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.ui.consoles.ConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;

public class RunConsole
extends IOConsole {
    public static final String ID = "containerLog";
    public static final String CONTAINER_LOG_TITLE = "ContainerLog.title";
    public static final String DEFAULT_ID = "__DEFAULT_ID__";
    private String containerId;
    private String id;
    private OutputStream outputStream;
    private boolean attached = false;

    public static RunConsole findConsole(String containerId) {
        if (containerId == null) {
            return null;
        }
        return RunConsole.findConsole(containerId, DEFAULT_ID);
    }

    public static RunConsole findConsole(IDockerContainer container) {
        if (container == null) {
            return null;
        }
        return RunConsole.findConsole(container.id(), DEFAULT_ID, container.name());
    }

    public static RunConsole findConsole(String containerId, String id) {
        return RunConsole.findConsole(containerId, id, containerId.substring(0, 8));
    }

    public static RunConsole findConsole(String containerId, String id, String name) {
        RunConsole ret = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole cons = iConsoleArray[n2];
            if (cons instanceof RunConsole && ((RunConsole)cons).containerId.equals(containerId) && ((RunConsole)cons).id.equals(id)) {
                ret = (RunConsole)cons;
            }
            ++n2;
        }
        if (ret == null) {
            ret = new RunConsole(containerId, id, name);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{ret});
        }
        return ret;
    }

    public void setTitle(String name) {
        this.setName(name);
    }

    public void attachToConsole(IDockerConnection connection) {
        IOConsoleInputStream in = this.getInputStream();
        Thread t = new Thread(() -> this.lambda$0(connection, (InputStream)in));
        t.start();
        this.attached = true;
    }

    public static void attachToTerminal(IDockerConnection connection, String containerId, DockerConsoleOutputStream out) {
        Thread t = new Thread(() -> {
            block9: {
                try {
                    DockerConnection conn = (DockerConnection)connection;
                    IDockerContainerInfo info = conn.getContainerInfo(containerId);
                    IDockerContainerState state = null;
                    if (info != null) {
                        state = info.state();
                    }
                    int sleepCounter = 0;
                    do {
                        if (state == null || !state.running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate()))) {
                            Thread.sleep(300L);
                            ++sleepCounter;
                        }
                        state = null;
                        info = conn.getContainerInfo(containerId);
                        if (info != null) {
                            state = info.state();
                            continue;
                        }
                        if (sleepCounter > 2) break;
                    } while (state == null || !state.running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate())));
                    Thread.sleep(300L);
                    state = null;
                    info = conn.getContainerInfo(containerId);
                    if (info != null) {
                        state = info.state();
                    }
                    if (state == null || !state.running().booleanValue()) {
                        if (out != null) {
                            out.notifyConsoleListeners(new byte[1], 0, 0);
                        }
                        return;
                    }
                    conn.attachCommand(containerId, null, out);
                }
                catch (Exception e) {
                    Activator.log(e);
                    if (out == null) break block9;
                    out.notifyConsoleListeners(new byte[1], 0, 0);
                }
            }
        });
        t.start();
    }

    public void attachToConsole(IDockerConnection connection, String containerId) {
        this.containerId = containerId;
        this.attachToConsole(connection);
    }

    public boolean isAttached() {
        return this.attached;
    }

    public static void removeConsole(RunConsole console) {
        console.closeOutputStream();
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
    }

    public void showConsole() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
    }

    public void closeOutputStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getOutputStream() {
        this.outputStream = new ConsoleOutputStream((OutputStream)this.newOutputStream());
        return this.outputStream;
    }

    private RunConsole(String containerId, String id, String name) {
        super(DVMessages.getFormattedString(CONTAINER_LOG_TITLE, name), ID, null, true);
        this.containerId = containerId;
        this.id = id;
    }

    private /* synthetic */ void lambda$0(IDockerConnection iDockerConnection, InputStream inputStream) {
        try {
            DockerConnection conn = (DockerConnection)iDockerConnection;
            if (conn.getContainerInfo(this.containerId).config().openStdin()) {
                IDockerContainerInfo info = conn.getContainerInfo(this.containerId);
                IDockerContainerState state = null;
                if (info != null) {
                    state = info.state();
                }
                int sleepCounter = 0;
                do {
                    if (state == null || !state.running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate()))) {
                        Thread.sleep(300L);
                        ++sleepCounter;
                    }
                    state = null;
                    info = conn.getContainerInfo(this.containerId);
                    if (info != null) {
                        state = info.state();
                        continue;
                    }
                    if (sleepCounter > 2) break;
                } while (state == null || !state.running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate())));
                Thread.sleep(300L);
                info = conn.getContainerInfo(this.containerId);
                if (info == null) {
                    return;
                }
                state = info.state();
                if (state.running().booleanValue()) {
                    conn.attachCommand(this.containerId, inputStream, null);
                }
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }
}

