/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TitleAreaDialogWithRadioButtons
extends TitleAreaDialog {
    private String selectedButton;
    private String title;
    private String bodyMsg;
    private int msgType;
    private List<Map.Entry<String, String>> userButtonList;
    private List<Button> widgetButtonList;

    public TitleAreaDialogWithRadioButtons(Shell parentShell, String title, String bodyMsg, List<Map.Entry<String, String>> userButtonList, int msgType) {
        super(parentShell);
        this.userButtonList = userButtonList;
        this.title = title;
        this.bodyMsg = bodyMsg;
        this.msgType = msgType;
        this.setHelpAvailable(false);
        this.selectedButton = null;
    }

    public void create() {
        super.create();
        this.setMessage(this.title, this.msgType);
        this.getShell().setSize(this.getInitialSize());
    }

    public String getSelectedButton() {
        return this.selectedButton;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(this.bodyMsg);
        this.widgetButtonList = new ArrayList<Button>();
        int buttonCount = 1;
        for (Map.Entry<String, String> usrbutton : this.userButtonList) {
            Button tmpButton = new Button(container, 16);
            tmpButton.setText(usrbutton.getValue());
            if (buttonCount == 1) {
                tmpButton.setSelection(true);
                ++buttonCount;
            }
            this.widgetButtonList.add(tmpButton);
        }
        return area;
    }

    protected void saveInput() {
        int i = 0;
        while (i < this.widgetButtonList.size()) {
            if (this.widgetButtonList.get(i).getSelection()) {
                this.selectedButton = this.userButtonList.get(i).getKey();
            }
            ++i;
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }
}

