/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.vagrant.ui.Activator;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.BaseVMCommandHandler;
import org.eclipse.linuxtools.internal.vagrant.ui.views.DVMessages;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenVagrantfileCommandHandler
extends BaseVMCommandHandler {
    private static final String OPEN_VM_FILE_MSG = "OpenVMFile.msg";
    private static final String OPEN_VM_FILE_TITLE = "OpenVMFile.title";

    @Override
    String getJobName(List<IVagrantVM> selectedVMs) {
        return DVMessages.getFormattedString(OPEN_VM_FILE_MSG, new String[0]);
    }

    @Override
    String getTaskName(IVagrantVM vm) {
        return DVMessages.getFormattedString(OPEN_VM_FILE_TITLE, vm.name(), vm.id(), vm.directory().getAbsolutePath());
    }

    @Override
    void executeInJob(IVagrantVM vm, IProgressMonitor monitor) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchPage activePage = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IPath vgFilePath = new Path(vm.directory().getAbsolutePath()).append("Vagrantfile");
            IFileStore file = EFS.getLocalFileSystem().getStore(vgFilePath);
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)activePage, (IFileStore)file);
            }
            catch (PartInitException e) {
                Activator.log(e);
            }
        });
    }
}

