/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.ui.internal;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadSourcesActionDelegate
implements IEditorActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(DownloadSourcesActionDelegate.class);

    public void setActiveEditor(IAction action, IEditorPart part) {
        if (part != null && part.getEditorInput() instanceof IClassFileEditorInput) {
            try {
                IClasspathManager buildpathManager = MavenJdtPlugin.getDefault().getBuildpathManager();
                IClassFileEditorInput input = (IClassFileEditorInput)part.getEditorInput();
                IClassFile element = input.getClassFile();
                while (element.getParent() != null) {
                    if (!((element = element.getParent()) instanceof IPackageFragmentRoot)) continue;
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (root.getSourceAttachmentPath() == null) {
                        buildpathManager.scheduleDownload(root, true, false);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                log.error("Could not schedule source download", (Throwable)ex);
            }
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

