/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.ui.internal.actions;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.jdt.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenJavaDocAction
extends ActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(OpenJavaDocAction.class);
    public static final String ID = "org.eclipse.m2e.openJavaDocAction";
    private IStructuredSelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void run(IAction action) {
        if (this.selection != null) {
            try {
                final ArtifactKey ak = SelectionUtil.getArtifactKey((Object)this.selection.getFirstElement());
                if (ak == null) {
                    OpenJavaDocAction.openDialog(Messages.OpenJavaDocAction_message1);
                    return;
                }
                new Job(NLS.bind((String)Messages.OpenJavaDocAction_job_open_javadoc, (Object)ak)){

                    protected IStatus run(IProgressMonitor monitor) {
                        OpenJavaDocAction.this.openJavaDoc(ak.getGroupId(), ak.getArtifactId(), ak.getVersion(), monitor);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.OpenJavaDocAction_error_title, (String)Messages.OpenJavaDocAction_error_message);
                    }
                });
            }
        }
    }

    protected void openJavaDoc(String groupId, String artifactId, String version, IProgressMonitor monitor) {
        final String name = String.valueOf(groupId) + ":" + artifactId + ":" + version + ":javadoc";
        try {
            IMaven maven = MavenPlugin.getMaven();
            List artifactRepositories = maven.getArtifactRepositories();
            Artifact artifact = maven.resolve(groupId, artifactId, version, "javadoc", "javadoc", artifactRepositories, monitor);
            final File file = artifact.getFile();
            if (file == null) {
                OpenJavaDocAction.openDialog(NLS.bind((String)Messages.OpenJavaDocAction_error_download, (Object)name));
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        String url = "jar:" + file.toURI().toString() + "!/index.html";
                        URL helpUrl = PlatformUI.getWorkbench().getHelpSystem().resolve(url, true);
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(4, name, name, name);
                        browser.openURL(helpUrl);
                    }
                    catch (PartInitException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            });
        }
        catch (CoreException ex) {
            log.error("Can't download Javadoc for " + name, (Throwable)ex);
            OpenJavaDocAction.openDialog(NLS.bind((String)Messages.OpenJavaDocAction_error_download, (Object)name));
        }
    }

    private static void openDialog(final String msg) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.OpenJavaDocAction_info_title, (String)msg);
            }
        });
    }
}

