/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.Map;
import java.util.WeakHashMap;

public interface ValidationContext {
    public void setValidationError(Object var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Aggregator
    implements ValidationContext {
        private ValidationContext delegate;
        private Map<Object, String> messages = new WeakHashMap<Object, String>();

        public Aggregator(ValidationContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setValidationError(Object source, String message) {
            if (message != null) {
                this.messages.put(source, message);
            } else {
                this.messages.remove(source);
            }
            if (this.delegate != null) {
                this.delegate.setValidationError(this, this.messages.isEmpty() ? null : this.formatMessage(this.messages));
            }
        }

        protected String formatMessage(Map<Object, String> messages) {
            if (messages.size() == 1) {
                return messages.values().iterator().next();
            }
            StringBuilder builder = new StringBuilder();
            for (String message : messages.values()) {
                if (builder.length() != 0) {
                    builder.append("\n");
                }
                builder.append("- " + message);
            }
            return builder.toString();
        }
    }
}

