/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugUIPlugin;
import org.osgi.framework.Bundle;

public class OTDebugImages {
    public static final String TEAM_ACTIVATED = "icons/team_act.gif";
    public static final String TEAM_IMPLICIT_ACTIVATED = "icons/team_act_implicit.gif";
    public static final String TEAM_INACTIVATED = "icons/team_inact.gif";
    public static final String SORT_TEAMS_BY_ACTIVATION_TIME = "icons/sort_by_activation.gif";
    public static final String SORT_TEAMS_BY_NAME = "icons/sort_by_name.gif";
    public static final String SORT_TEAMS_BY_INSTANTIATION = "icons/sort_by_instantiation.gif";
    public static final String UPDATE_TEAM_VIEW_ACTION = "icons/refresh.gif";

    public static void register() {
        OTDebugImages.checkBundleState();
        OTDebugUIPlugin plugin = OTDebugUIPlugin.getDefault();
        Bundle bundle = plugin.getBundle();
        ImageRegistry registry = plugin.getImageRegistry();
        OTDebugImages.register(TEAM_ACTIVATED, bundle, registry);
        OTDebugImages.register(TEAM_IMPLICIT_ACTIVATED, bundle, registry);
        OTDebugImages.register(TEAM_INACTIVATED, bundle, registry);
        OTDebugImages.register(SORT_TEAMS_BY_ACTIVATION_TIME, bundle, registry);
        OTDebugImages.register(SORT_TEAMS_BY_NAME, bundle, registry);
        OTDebugImages.register(SORT_TEAMS_BY_INSTANTIATION, bundle, registry);
        OTDebugImages.register(UPDATE_TEAM_VIEW_ACTION, bundle, registry);
    }

    public static ImageDescriptor get(String image) {
        OTDebugImages.checkBundleState();
        return OTDebugUIPlugin.getDefault().getImageRegistry().getDescriptor(image);
    }

    static void register(String icon, Bundle bundle, ImageRegistry registry) {
        URL imageURL = bundle.getEntry(icon);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageURL);
        registry.put(icon, desc);
    }

    private static void checkBundleState() {
        if (OTDebugUIPlugin.getDefault().getBundle().getState() != 32) {
            throw new IllegalStateException("Bundle not active: " + OTDebugUIPlugin.getDefault().getBundle().getBundleId());
        }
    }
}

