/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.targlets.CSpexGenerator;
import org.eclipse.oomph.targlets.ComponentExtension;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.impl.CSpecGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ComponentExtGeneratorImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpexGeneratorImpl
extends ModelElementImpl
implements CSpexGenerator {
    private static final IPath CSPEX_PATH = new Path("buckminster.cspex");

    protected CSpexGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.CSPEX_GENERATOR;
    }

    @Override
    public void generateIUs(IProject project, String qualifierReplacement, Map<String, Version> iuVersions, EList<IInstallableUnit> result) throws Exception {
        if (!result.isEmpty()) {
            IInstallableUnit mainIU = (IInstallableUnit)result.get(0);
            IFile file = project.getFile(CSPEX_PATH);
            if (file.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = file.getContents();
                    ComponentExtension componentExtension = TargletFactory.eINSTANCE.createComponentExtension();
                    DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                    Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)inputStream);
                    CSpecGeneratorImpl.handleBuckminsterDependencies(rootElement, componentExtension);
                    ComponentExtGeneratorImpl.modifyIU(componentExtension, mainIU);
                }
                finally {
                    IOUtil.closeSilent((Closeable)inputStream);
                }
            }
        }
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

