/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.ui.IFortranAPIHelpProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ContributedAPIDocs {
    public static final String API_HELP_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.photran.ui.apiHelpProvider";

    public static String getAPIHelpAsHTML(ITextEditor editor, String apiName, String precedingText) {
        IHelpResource[] resources = ContributedAPIDocs.getAPIHelp(editor, apiName, precedingText);
        if (resources.length == 0) {
            return null;
        }
        try {
            HelpSystem.getContext((String)"org.eclipse.photran.ui.editor");
            String href = resources[0].getHref();
            return ContributedAPIDocs.read(HelpSystem.getHelpContent((String)href));
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private static String read(InputStream in) {
        if (in == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int ch = in.read();
            while (ch >= 0) {
                sb.append((char)ch);
                ch = in.read();
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static IHelpResource[] getAPIHelp(ITextEditor fortranEditor, String apiName, String precedingText) {
        ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(API_HELP_PROVIDER_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                IFortranAPIHelpProvider helpProvider = (IFortranAPIHelpProvider)config.createExecutableExtension("class");
                IHelpResource[] resources = helpProvider.getHelpResources(fortranEditor, apiName, precedingText);
                if (resources != null) {
                    IHelpResource[] iHelpResourceArray = resources;
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IHelpResource resource = iHelpResourceArray[n4];
                        if (resource != null) {
                            helpResources.add(resource);
                        }
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                FortranUIPlugin.log(e);
            }
            ++n2;
        }
        return helpResources.toArray(new IHelpResource[helpResources.size()]);
    }

    private ContributedAPIDocs() {
    }
}

