/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.collection.Scripts;
import org.eclipse.php.composer.api.objects.Script;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.dialogs.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScriptDialog
extends Dialog {
    private Combo eventControl;
    private Text handlerControl;
    private Script script;
    private Script.HandlerValue handlerValue;
    private boolean handlerEnabled = true;
    private boolean eventEnabled = true;

    public ScriptDialog(Shell parentShell, Script script, Script.HandlerValue handlerValue) {
        super(parentShell);
        this.script = script;
        this.handlerValue = handlerValue;
    }

    public ScriptDialog(IShellProvider parentShell, Script script, Script.HandlerValue handlerValue) {
        super(parentShell);
        this.script = script;
        this.handlerValue = handlerValue;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ScriptDialog_Title);
        this.getShell().setImage(ComposerUIPluginImages.EVENT.createImage());
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        Label lblEvent = new Label(contents, 0);
        GridData gd_lblEvent = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblEvent.widthHint = 100;
        lblEvent.setLayoutData((Object)gd_lblEvent);
        lblEvent.setText(Messages.ScriptDialog_EventLabel);
        this.eventControl = new Combo(contents, 8);
        this.eventControl.setEnabled(this.eventEnabled);
        GridData gd_eventControl = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_eventControl.widthHint = 175;
        this.eventControl.setLayoutData((Object)gd_eventControl);
        this.eventControl.setItems(Scripts.getEvents());
        this.eventControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptDialog.this.script.setScript(ScriptDialog.this.eventControl.getText());
            }
        });
        if (this.script.getScript() != null) {
            this.eventControl.setText(this.script.getScript());
        }
        Label lblHandler = new Label(contents, 0);
        lblHandler.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblHandler.setText(Messages.ScriptDialog_HandlerLabel);
        this.handlerControl = new Text(contents, 2048);
        this.handlerControl.setEnabled(this.handlerEnabled);
        this.handlerControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.handlerControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptDialog.this.handlerValue.setValue(ScriptDialog.this.handlerControl.getText());
            }
        });
        String text = this.handlerValue.getAsString();
        if (text != null) {
            this.handlerControl.setText(text);
        } else {
            this.handlerControl.setText("");
        }
        return contents;
    }

    public void setHandlerEnabled(boolean enabled) {
        this.handlerEnabled = enabled;
        if (this.handlerControl != null) {
            this.handlerControl.setEnabled(this.handlerEnabled);
        }
    }

    public void setEventEnabled(boolean enabled) {
        this.eventEnabled = enabled;
        if (this.eventControl != null) {
            this.eventControl.setEnabled(this.eventEnabled);
        }
    }

    public Script getScript() {
        return this.script;
    }

    public Script.HandlerValue getHandlerValue() {
        return this.handlerValue;
    }
}

