/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class NamespaceDeclaration
extends TypeDeclaration
implements IPHPDocAwareDeclaration {
    public static final String GLOBAL = "__global__namespace__";
    private PHPDocBlock phpDoc;
    private boolean braketed = true;

    public NamespaceDeclaration(int start, int end, int nameStart, int nameEnd, String className, Block body, PHPDocBlock phpDoc) {
        super(className, nameStart, nameEnd, start, end);
        this.phpDoc = phpDoc;
        if (body == null) {
            body = new Block(start, end);
        }
        this.setBody(body);
    }

    public void setBracketed(boolean bracketed) {
        this.braketed = bracketed;
    }

    public boolean isBracketed() {
        return this.braketed;
    }

    public boolean isGlobal() {
        return this.getName() == GLOBAL;
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public void addStatement(Statement statement) {
        this.getBody().addStatement((ASTNode)statement);
        this.getBody().setEnd(statement.sourceEnd());
        this.setEnd(statement.sourceEnd());
    }

    public int getKind() {
        return 69;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

