/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractClassInstantiationStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;

public class ExceptionClassInstantiationStrategy
extends AbstractClassInstantiationStrategy {
    private static final String CORE_PHP = "Core.php";
    private static final String BASIC_PHP = "basic.php";
    private static final String EXCEPTION = "Exception";
    private IType exceptionType;

    public ExceptionClassInstantiationStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType exceptionType = this.getExceptionType();
        if (exceptionType == null) {
            return super.getTypes(context);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        ISourceModule sourceModule = context.getSourceModule();
        IScriptProject scriptProject = sourceModule.getScriptProject();
        try {
            ITypeHierarchy typeHierarchy = scriptProject != null ? exceptionType.newTypeHierarchy(scriptProject, (IProgressMonitor)new NullProgressMonitor()) : exceptionType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] classes = typeHierarchy.getAllSubtypes(exceptionType);
            HashSet<IType> set = new HashSet<IType>();
            set.add(exceptionType);
            set.addAll(Arrays.asList(classes));
            String prefix = context.getPrefix();
            if (prefix.trim().length() != 0) {
                IType[] types = super.getTypes(context);
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    if (set.contains(type)) {
                        result.add(type);
                    }
                    ++i;
                }
            } else {
                result.addAll(set);
            }
        }
        catch (ModelException modelException) {
            return super.getTypes(context);
        }
        return result.toArray(new IType[result.size()]);
    }

    protected IType getExceptionType() {
        if (this.exceptionType != null) {
            return this.exceptionType;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        IType[] exceptionTypes = PHPModelAccess.getDefault().findTypes(EXCEPTION, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        int i = 0;
        while (i < exceptionTypes.length) {
            if (this.isExceptionType(exceptionTypes[i])) {
                this.exceptionType = exceptionTypes[i];
                break;
            }
            ++i;
        }
        return this.exceptionType;
    }

    private boolean isExceptionType(IType iType) {
        return EXCEPTION.equals(iType.getElementName()) && (CORE_PHP.equals(iType.getParent().getElementName()) || BASIC_PHP.equals(iType.getParent().getElementName()));
    }
}

