/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.phar.PharPath;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.model.BreakpointSet;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupDirector;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPCompositeSourceContainer;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.DBGpExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.DBGpLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.TimedEvent;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.EngineTypes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBGpTarget
extends DBGpElement
implements IPHPDebugTarget,
IDBGpDebugTarget,
IStep,
IBreakpointManagerListener,
IDBGpSessionListener {
    private String sessionID;
    private String ideKey;
    private boolean webLaunch = false;
    private boolean multiSessionManaged = false;
    private IProcess process;
    private String stopDebugURL;
    private volatile int targetState;
    private static final int STATE_CREATE = 0;
    private static final int STATE_INIT_SESSION_WAIT = 1;
    private static final int STATE_STARTED_SUSPENDED = 2;
    private static final int STATE_STARTED_RUNNING = 3;
    private static final int STATE_STARTED_SESSION_WAIT = 4;
    private static final int STATE_TERMINATING = 5;
    private static final int STATE_TERMINATED = 6;
    private static final int STATE_DISCONNECTED = 7;
    private String projectScript;
    private String name;
    private ILaunch launch;
    private DBGpThread langThread;
    private IThread[] allThreads;
    private int currentStackLevel;
    private IStackFrame[] stackFrames;
    private IStackFrame[] previousFrames;
    private IVariable[] currentVariables;
    private DBGpBreakpointFacade bpFacade;
    private IVariable[] superGlobalVars;
    private Vector<DBGpBreakpointCmd> DBGpCmdQueue = new Vector();
    private volatile DBGpSession session;
    private DBGpPreferences sessionPreferences;
    private Object sessionMutex = new Object();
    private Object commandMutex = new Object();
    private TimedEvent te = new TimedEvent();
    private boolean stopAtStart;
    private boolean asyncSupported;
    private boolean stepping;
    private PathMapper pathMapper = null;
    private DebugOutput debugOutput = new DebugOutput();
    private boolean hasInitialSource = true;
    private BreakpointSet breakpointSet;

    private DBGpTarget() {
        super(null);
        this.setState(0);
        this.ideKey = DBGpSessionHandler.getInstance().getIDEKey();
        this.allThreads = new IThread[0];
        this.fireCreationEvent();
    }

    public DBGpTarget(ILaunch launch, String projectRelativeScript, String ideKey, String sessionID, boolean stopAtStart) {
        this();
        this.stopAtStart = stopAtStart;
        this.launch = launch;
        this.projectScript = projectRelativeScript;
        this.ideKey = ideKey;
        this.webLaunch = false;
        this.sessionID = sessionID;
        this.process = null;
        this.stopDebugURL = null;
    }

    public DBGpTarget(ILaunch launch, String workspaceRelativeScript, String stopDebugURL, String ideKey, String sessionID, boolean stopAtStart) {
        this();
        this.stopAtStart = stopAtStart;
        this.launch = launch;
        this.projectScript = workspaceRelativeScript;
        this.ideKey = ideKey;
        this.webLaunch = true;
        this.sessionID = sessionID;
        this.stopDebugURL = stopDebugURL;
        this.process = null;
    }

    @Override
    public void waitForInitialSession(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs, IProgressMonitor launchMonitor) {
        this.configureInitialState(facade, sessionPrefs);
        try {
            while (!(this.session != null || this.launch.isTerminated() || this.isTerminating() || launchMonitor == null || launchMonitor.isCanceled())) {
                this.te.waitForEvent(500L);
            }
            this.sessionReceived(launchMonitor);
        }
        catch (Exception e) {
            this.terminateDebugTarget(true);
        }
    }

    public void sessionReceived(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs) {
        this.configureInitialState(facade, sessionPrefs);
        this.sessionReceived(null);
    }

    @Override
    public void configureInitialState(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs) {
        this.bpFacade = facade;
        this.sessionPreferences = sessionPrefs;
        this.setState(1);
    }

    private void sessionReceived(IProgressMonitor launchMonitor) {
        boolean launchIsCanceled = false;
        if (this.session != null && this.session.isActive()) {
            if (launchMonitor != null) {
                launchIsCanceled = launchMonitor.isCanceled();
            }
            if (!(this.isTerminating() || this.launch.isTerminated() || launchIsCanceled)) {
                this.langThread = new DBGpThread(this);
                this.allThreads = new IThread[]{this.langThread};
                this.langThread.fireCreationEvent();
                IBreakpointManager bpmgr = DebugPlugin.getDefault().getBreakpointManager();
                bpmgr.addBreakpointListener((IBreakpointListener)this);
                bpmgr.addBreakpointManagerListener((IBreakpointManagerListener)this);
                this.testInitialScriptLocating();
                if (this.session != null) {
                    this.initiateSession();
                }
            } else {
                this.session.endSession();
                this.terminateDebugTarget(true);
            }
        } else {
            this.terminateDebugTarget(true);
        }
    }

    private void testInitialScriptLocating() {
        IFile file;
        String initScript = this.session.getInitialScript();
        if (initScript != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(initScript))) == null && this.pathMapper != null && this.pathMapper.getLocalFile(initScript) == null) {
            if (this.projectScript != null) {
                this.handlePDTSessionInitiation(initScript);
            } else {
                this.handleRemoteSessionInitiation(initScript);
            }
        }
    }

    private void handlePDTSessionInitiation(String initScript) {
        VirtualPath vpScr = new VirtualPath(this.projectScript);
        VirtualPath vpInit = new VirtualPath(initScript);
        if (vpScr.getLastSegment().equals(vpInit.getLastSegment())) {
            PathEntry pe = new PathEntry(this.projectScript, PathEntry.Type.WORKSPACE, (Object)ResourcesPlugin.getWorkspace().getRoot());
            this.pathMapper.addEntry(initScript, pe, PathMapper.Mapping.MappingSource.ENVIRONMENT);
        } else {
            try {
                DebugSearchEngine.find(initScript, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleRemoteSessionInitiation(String initScript) {
        try {
            PathEntry pe = DebugSearchEngine.find(this.pathMapper, initScript, null, this);
            if (pe != null) {
                Object container = pe.getContainer();
                if (container != null && container instanceof IResource) {
                    IResource res = (IResource)container;
                    IProject prj = res.getProject();
                    PHPSourceLookupDirector dir = (PHPSourceLookupDirector)this.getLaunch().getSourceLocator();
                    ISourceContainer[] containers = new ISourceContainer[]{new PHPCompositeSourceContainer(prj, null)};
                    dir.setSourceContainers(containers);
                }
            } else if (!this.isTerminated()) {
                this.hasInitialSource = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initiateSession() {
        if (!this.hasState(1, 4)) {
            DBGpLogger.logWarning("initiateSession in Wrong State: " + this.targetState, this, null);
        }
        this.stackFrames = null;
        this.currentVariables = null;
        this.superGlobalVars = null;
        this.clearQueuedBpCmds();
        this.debugOutput = new DebugOutput();
        this.session.startSession();
        this.setState(2);
        this.negotiateDBGpFeatures();
        this.loadPredefinedBreakpoints();
        if (!this.hasInitialSource) {
            this.setState(3);
            this.session.sendAsyncCmd("run");
            this.hasInitialSource = true;
            return;
        }
        if (!this.stopAtStart) {
            this.setState(3);
            this.session.sendAsyncCmd("run");
            return;
        }
        this.suspended(16);
        try {
            this.stepInto();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess proc) {
        this.process = proc;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated() || this.hasState(4)) {
            return new IThread[0];
        }
        return this.allThreads;
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length > 0;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = this.isWebLaunch() || this.multiSessionManaged ? PHPDebugCoreMessages.XDebug_DBGpTarget_1 : (this.projectScript == null ? (this.session != null ? this.session.getInitialScript() : PHPDebugCoreMessages.XDebug_DBGpTarget_2) : this.projectScript);
        }
        return this.name;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return !this.hasState(6, 0, 7);
    }

    public boolean isTerminated() {
        return this.hasState(6);
    }

    private boolean isTerminating() {
        return this.hasState(6, 5);
    }

    public boolean hasStarted() {
        return this.hasState(3, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        if (this.isTerminating()) {
            if (this.session == null && this.hasState(5)) {
                this.terminateDebugTarget(true);
            }
            return;
        }
        DBGpSessionHandler.getInstance().removeSessionListener(this);
        if (this.hasState(2)) {
            Object object = this.sessionMutex;
            synchronized (object) {
                if (this.session != null && this.session.isActive()) {
                    this.setState(5);
                    this.session.sendAsyncCmd("stop");
                } else {
                    this.terminateDebugTarget(true);
                }
            }
        } else {
            this.terminateDebugTarget(true);
            if (this.isWebLaunch()) {
                this.sendStopDebugURL();
            }
        }
    }

    private void sendStopDebugURL() {
        if (this.stopDebugURL == null) {
            return;
        }
        DBGpLogger.debug("browser is not null, sending " + this.stopDebugURL);
        try {
            PHPDebugUtil.openLaunchURL(this.stopDebugURL, false);
        }
        catch (DebugException e) {
            DBGpLogger.logException("Failed to send stop XDebug session URL: " + this.stopDebugURL, this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded() {
        boolean unexpectedTermination = false;
        Object object = this.sessionMutex;
        synchronized (object) {
            this.session = null;
            if (this.hasState(5)) {
                if (this.isWebLaunch() && !this.isMultiSessionManaged()) {
                    this.sendStopDebugURL();
                }
                this.terminateDebugTarget(true);
            } else {
                unexpectedTermination = this.isSuspended();
                if (this.isWebLaunch() && !this.isMultiSessionManaged()) {
                    if (this.isSuspended() && DebugPlugin.getDefault() != null) {
                        this.fireResumeEvent(1);
                        this.langThread.fireResumeEvent(1);
                    }
                    this.stepping = false;
                    this.setState(4);
                    this.langThread.setBreakpoints(null);
                } else {
                    this.terminateDebugTarget(true);
                }
            }
        }
        if (unexpectedTermination && DebugPlugin.getDefault() != null) {
            final String errorMessage = PHPDebugCoreMessages.XDebugMessage_unexpectedTermination;
            Status status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null);
            DebugPlugin.log((IStatus)status);
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)errorMessage);
                    }
                });
            }
        }
    }

    public void terminateDebugTarget(boolean isTerminate) {
        if (!this.hasState(6)) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            if (DebugPlugin.getDefault() != null) {
                IBreakpointManager bpmgr = DebugPlugin.getDefault().getBreakpointManager();
                bpmgr.removeBreakpointListener((IBreakpointListener)this);
                bpmgr.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            }
            if (isTerminate && this.hasState(3)) {
                this.setState(5);
                if (this.process != null) {
                    try {
                        this.process.terminate();
                    }
                    catch (DebugException debugException) {}
                } else if (this.session != null) {
                    this.session.endSession();
                }
            }
            this.setState(6);
            if (this.session != null) {
                this.session.endSession();
            }
            if (this.langThread != null && DebugPlugin.getDefault() != null) {
                this.langThread.fireTerminateEvent();
            }
            this.stepping = false;
            if (DebugPlugin.getDefault() != null) {
                this.fireTerminateEvent();
            }
        }
        if (!this.isMultiSessionManaged()) {
            try {
                this.getLaunch().terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.asyncSupported;
    }

    public boolean isSuspended() {
        return this.hasState(2);
    }

    public boolean canStepInto() {
        return !this.isStepping() && this.isSuspended();
    }

    public boolean canStepOver() {
        return !this.isStepping() && this.isSuspended();
    }

    public boolean canStepReturn() {
        try {
            if (!this.isStepping() && this.isSuspended() && this.getCurrentStackFrames().length > 1) {
                return true;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return false;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() throws DebugException {
        Object object = this.commandMutex;
        synchronized (object) {
            if (!this.canStepInto()) {
                return;
            }
            this.stepping = true;
            this.resumed(1);
        }
        this.session.sendAsyncCmd("step_into");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() throws DebugException {
        Object object = this.commandMutex;
        synchronized (object) {
            if (!this.canStepOver()) {
                return;
            }
            this.stepping = true;
            this.resumed(2);
        }
        this.session.sendAsyncCmd("step_over");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepReturn() throws DebugException {
        Object object = this.commandMutex;
        synchronized (object) {
            if (!this.canStepReturn()) {
                return;
            }
            this.stepping = true;
            this.resumed(4);
        }
        this.session.sendAsyncCmd("step_out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        Object object = this.commandMutex;
        synchronized (object) {
            if (!this.canResume()) {
                return;
            }
            this.stepping = false;
            this.resumed(1);
        }
        object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.sendAsyncCmd("run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.sendAsyncCmd("break");
            }
        }
    }

    public boolean canDisconnect() {
        return this.hasState(3, 2);
    }

    public void disconnect() throws DebugException {
        if (this.isTerminating()) {
            return;
        }
        if (this.hasState(3, 2)) {
            this.setState(7);
            if (this.session != null) {
                this.clearQueuedBpCmds();
                if (!this.isWebLaunch()) {
                    if (this.multiSessionManaged && this.session.getEngineType() == EngineTypes.Xdebug && this.versionCheckLT(this.session.getEngineVersion(), "2.0.2")) {
                        this.session.sendSyncCmd("stop");
                    } else {
                        this.session.sendAsyncCmd("detach");
                    }
                    this.terminateDebugTarget(false);
                } else {
                    if (this.session.getEngineType() == EngineTypes.Xdebug && this.versionCheckLT(this.session.getEngineVersion(), "2.0.2")) {
                        this.session.sendSyncCmd("stop");
                    } else {
                        this.session.sendAsyncCmd("detach");
                    }
                    this.stepping = false;
                    this.langThread.setBreakpoints(null);
                    this.setState(4);
                    this.resumed(1);
                }
            }
        }
    }

    private boolean versionCheckLT(String engineVersion, String requiredVersion) {
        boolean isLessThan = true;
        boolean isEqual = true;
        StringTokenizer stEngine = new StringTokenizer(engineVersion, ".");
        StringTokenizer stCheck = new StringTokenizer(requiredVersion, ".");
        while (stEngine.hasMoreTokens()) {
            String engineValStr = stEngine.nextToken();
            if (!stCheck.hasMoreTokens()) continue;
            String checkValStr = stCheck.nextToken();
            try {
                int engineVal = Integer.parseInt(engineValStr);
                try {
                    int checkVal = Integer.parseInt(checkValStr);
                    if (engineVal > checkVal) {
                        isLessThan = false;
                        isEqual = false;
                    }
                    if (engineVal == checkVal) continue;
                    isEqual = false;
                }
                catch (NumberFormatException checkVal) {}
            }
            catch (NumberFormatException nfe) {
                int engineVal = this.getNumber(engineValStr);
                isEqual = false;
                try {
                    int checkVal = Integer.parseInt(checkValStr);
                    if (engineVal <= checkVal) continue;
                    isLessThan = false;
                    isEqual = false;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (stCheck.hasMoreTokens()) {
            isEqual = false;
        }
        return isLessThan && !isEqual;
    }

    private int getNumber(String engineValStr) {
        int x = -1;
        int i = 0;
        while (i < engineValStr.length()) {
            char ch = engineValStr.charAt(i);
            if (!Character.isDigit(ch) && i > 0) {
                x = Integer.parseInt(engineValStr.substring(0, i));
                break;
            }
            ++i;
        }
        return x;
    }

    public boolean isDisconnected() {
        return this.hasState(7, 6);
    }

    private void resumed(int detail) {
        this.setState(3);
        this.processQueuedBpCmds();
        this.fireResumeEvent(detail);
        this.langThread.fireResumeEvent(detail);
    }

    public void suspended(int detail) {
        this.setState(2);
        this.processQueuedBpCmds();
        this.previousFrames = this.stackFrames;
        this.stackFrames = null;
        this.currentVariables = null;
        this.superGlobalVars = null;
        this.stepping = false;
        this.fireSuspendEvent(detail);
        this.langThread.fireSuspendEvent(detail);
    }

    private void negotiateDBGpFeatures() {
        String supported;
        Node child;
        DBGpResponse resp = this.session.sendSyncCmd("feature_set", "-n show_hidden -v 1");
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n extended_properties -v " + this.getUseExtendedProperties());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n max_depth -v " + this.getMaxDepth());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n max_children -v " + this.getMaxChildren());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n max_data -v " + this.getMaxData());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_get", "-n encoding");
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && (child = resp.getParentNode().getFirstChild()) != null) {
            String data = child.getNodeValue();
            try {
                "abcdefg".getBytes(data);
                this.session.setSessionEncoding(data);
            }
            catch (UnsupportedEncodingException uee) {
                DBGpLogger.logWarning("encoding from debug engine invalid", this, uee);
            }
        }
        this.asyncSupported = false;
        resp = this.session.sendSyncCmd("feature_get", "-n supports_async");
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && (child = resp.getParentNode().getFirstChild()) != null && (supported = child.getNodeValue()) != null && supported.equals("1")) {
            this.asyncSupported = true;
        }
        resp = this.session.sendSyncCmd("stdout", "-c " + this.getCaptureStdout());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("stderr", "-c " + this.getCaptureStderr());
        DBGpUtils.isGoodDBGpResponse(this, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IStackFrame[] getCurrentStackFrames() throws DebugException {
        if (this.stackFrames == null) {
            this.currentStackLevel = 0;
            this.stackFrames = new IStackFrame[0];
            Object object = this.sessionMutex;
            synchronized (object) {
                DBGpResponse resp;
                if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("stack_get"))) {
                    Node parent = resp.getParentNode();
                    NodeList stackNodes = parent.getChildNodes();
                    this.stackFrames = new IStackFrame[stackNodes.getLength()];
                    int i = 0;
                    while (i < stackNodes.getLength()) {
                        Node stackNode = stackNodes.item(i);
                        if (i == 0 && this.previousFrames != null && this.previousFrames.length != 0) {
                            this.stackFrames[0] = this.mergeFrame((DBGpStackFrame)this.previousFrames[0], new DBGpStackFrame(this.langThread, stackNode));
                        } else {
                            this.stackFrames[i] = new DBGpStackFrame(this.langThread, stackNode);
                        }
                        ++i;
                    }
                    this.currentStackLevel = stackNodes.getLength() - 1;
                }
            }
        }
        return this.stackFrames;
    }

    private IStackFrame mergeFrame(DBGpStackFrame previous, DBGpStackFrame incoming) throws DebugException {
        if (previous.getThread() == incoming.getThread() && previous.getName().equals(incoming.getName()) && previous.getStackLevel().equals(incoming.getStackLevel()) && previous.getSourceName().equals(incoming.getSourceName()) && previous.getQualifiedFile().equals(incoming.getQualifiedFile())) {
            previous.update(incoming.getDescriptor());
            return previous;
        }
        return incoming;
    }

    private IVariable[] getContextLocalVars(String level) {
        DBGpResponse resp = this.session.sendSyncCmd("context_get", "-d " + level);
        return this.parseVarResp(resp, level);
    }

    private IVariable[] getSuperGlobalVars() {
        if (this.superGlobalVars == null) {
            DBGpResponse resp = this.session.sendSyncCmd("context_get", "-c 1");
            this.superGlobalVars = this.parseVarResp(resp, "-1");
        }
        return this.superGlobalVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables(String level) {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                if (level.equals("0")) {
                    if (this.currentVariables == null) {
                        this.currentVariables = this.getContextAtLevel(level);
                        return this.currentVariables;
                    }
                    DBGpLogger.debug("getVariables: returning cached variables");
                    return this.currentVariables;
                }
                return this.getContextAtLevel(level);
            }
            return new IVariable[0];
        }
    }

    private IVariable[] getContextAtLevel(String level) {
        boolean getSuperGlobals = this.showGLobals();
        IVariable[] globals = null;
        globals = getSuperGlobals ? this.getSuperGlobalVars() : new IVariable[]{};
        IVariable[] locals = this.getContextLocalVars(level);
        int totalLength = globals.length + locals.length;
        Object[] merged = new IVariable[totalLength];
        if (globals.length > 0) {
            System.arraycopy(globals, 0, merged, 0, globals.length);
        }
        if (locals.length > 0) {
            System.arraycopy(locals, 0, merged, globals.length, locals.length);
        }
        this.setContextFacets((IVariable[])merged);
        VariablesUtil.sortContextMembers(merged);
        return merged;
    }

    private void setContextFacets(IVariable[] contextVariables) {
        int i = 0;
        while (i < contextVariables.length) {
            if (contextVariables[i] instanceof DBGpVariable) {
                DBGpVariable dbgpVariable = (DBGpVariable)contextVariables[i];
                try {
                    String endName = dbgpVariable.getName();
                    if (VariablesUtil.isThis(endName)) {
                        dbgpVariable.addFacets(IVariableFacet.Facet.KIND_THIS);
                    } else if (VariablesUtil.isSuperGlobal(endName)) {
                        dbgpVariable.addFacets(IVariableFacet.Facet.KIND_SUPER_GLOBAL);
                    } else if (VariablesUtil.isClassIndicator(endName)) {
                        dbgpVariable.addFacets(IVariableFacet.Facet.VIRTUAL_CLASS);
                    } else {
                        dbgpVariable.addFacets(IVariableFacet.Facet.KIND_LOCAL);
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private IVariable[] parseVarResp(DBGpResponse resp, String reportedLevel) {
        ArrayList<DBGpStackVariable> variables = new ArrayList<DBGpStackVariable>();
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && resp.getErrorCode() == 0) {
            Node parent = resp.getParentNode();
            NodeList properties = parent.getChildNodes();
            int i = 0;
            while (i < properties.getLength()) {
                Node property = properties.item(i);
                if (!this.shouldSkip(property)) {
                    variables.add(new DBGpStackVariable(this, property, Integer.valueOf(reportedLevel), new IVariableFacet.Facet[0]));
                }
                ++i;
            }
        }
        return variables.toArray(new DBGpVariable[variables.size()]);
    }

    private boolean shouldSkip(Node property) {
        String type = DBGpResponse.getAttribute(property, "type");
        return type.equalsIgnoreCase("uninitialized");
    }

    public boolean setProperty(DBGpVariable var, String data) {
        String encoded;
        try {
            encoded = Base64.encode(data.getBytes(this.getBinaryEncoding()));
        }
        catch (UnsupportedEncodingException e1) {
            DBGpLogger.logException("unexpected encoding problem", this, e1);
            encoded = Base64.encode(data.getBytes());
        }
        String fullName = var.getFullName();
        String stackLevel = String.valueOf(var.getStackLevel());
        String args = "-n " + fullName + " -d " + stackLevel + " -l " + encoded.length() + " -- " + encoded;
        if (var.getDataType() == IPHPDataType.DataType.PHP_STRING) {
            args = "-t string " + args;
        }
        DBGpResponse resp = this.session.sendSyncCmd("property_set", args);
        boolean success = false;
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && resp.getTopAttribute("success").equals("1")) {
            if (!stackLevel.equals("0")) {
                this.currentVariables = null;
                this.superGlobalVars = null;
            }
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getProperty(String fullName, String stackLevel, int page) {
        if (fullName != null && fullName.trim().length() != 0) {
            String args = "-n " + fullName + " -d " + stackLevel + " -p " + page;
            if (stackLevel.equals("-1")) {
                args = "-n " + fullName + " -d " + this.getCurrentStackLevel() + " -p " + page;
            }
            Object object = this.sessionMutex;
            synchronized (object) {
                DBGpResponse resp;
                if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("property_get", args))) {
                    return resp.getParentNode().getFirstChild();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getCompleteString(String fullName, String stackLevel, int length) {
        if (fullName != null && fullName.trim().length() != 0) {
            String args = "-n " + fullName + " -d " + stackLevel;
            if (stackLevel.equals("-1")) {
                args = "-n " + fullName + " -d " + this.getCurrentStackLevel();
            }
            args = String.valueOf(args) + " -m " + length;
            Object object = this.sessionMutex;
            synchronized (object) {
                DBGpResponse resp;
                if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("property_value", args))) {
                    return resp.getParentNode();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node eval(String toEval) {
        String encoded = Base64.encode(this.getSessionEncodingBytes(toEval));
        String args = "-- " + encoded;
        Node response = null;
        Object object = this.sessionMutex;
        synchronized (object) {
            DBGpResponse resp;
            if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("eval", args))) {
                response = resp.getParentNode().getFirstChild();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node eval(String toEval, int page) {
        String encoded = Base64.encode(this.getSessionEncodingBytes(toEval));
        String args = " -- " + encoded;
        Node response = null;
        Object object = this.sessionMutex;
        synchronized (object) {
            DBGpResponse resp;
            if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("eval", "-p " + String.valueOf(page) + args))) {
                response = resp.getParentNode().getFirstChild();
            }
        }
        return response;
    }

    private synchronized void setState(int newState) {
        if (DBGpLogger.debugState()) {
            String newStateStr = "";
            switch (newState) {
                case 0: {
                    newStateStr = "STATE_CREATE";
                    break;
                }
                case 7: {
                    newStateStr = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    newStateStr = "INIT_SESSION_WAIT";
                    break;
                }
                case 3: {
                    newStateStr = "STATE_STARTED_RUNNING";
                    break;
                }
                case 4: {
                    newStateStr = "STATE_STARTED_SESSION_WAIT";
                    break;
                }
                case 2: {
                    newStateStr = "STATE_STARTED_SUSPENDED";
                    break;
                }
                case 6: {
                    newStateStr = "STATE_TERMINATED";
                    break;
                }
                case 5: {
                    newStateStr = "STATE_TERMINATING";
                }
            }
            DBGpLogger.debug("State Change: " + newStateStr);
        }
        this.targetState = newState;
    }

    private boolean hasState(int ... state) {
        int i = 0;
        while (i < state.length) {
            if (this.targetState == state[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getCurrentStackLevel() {
        return this.currentStackLevel;
    }

    private String mapToExternalFileIfRequired(DBGpBreakpoint bp) {
        String internalFile = "";
        String mappedFileName = null;
        if (this.pathMapper != null) {
            if (bp.getIFile() != null) {
                internalFile = bp.getIFile().getFullPath().toString();
                mappedFileName = this.pathMapper.getRemoteFile(internalFile);
            }
            if (mappedFileName == null) {
                internalFile = bp.getFileName();
                mappedFileName = this.pathMapper.getRemoteFile(internalFile);
            }
        }
        if (mappedFileName == null) {
            DBGpLogger.debug("outbound File '" + internalFile + "' Not remapped");
            mappedFileName = bp.getFileName();
        } else if (DBGpLogger.debugBP()) {
            String mapMsg = "remapped eclipse file: '" + internalFile + "' to '" + mappedFileName + "'";
            DBGpLogger.debug(mapMsg);
        }
        return mappedFileName;
    }

    public String mapToWorkspaceFileIfRequired(String decodedFile) {
        String mappedFile = null;
        PathEntry mappedPathEntry = null;
        File fileSystemFile = new File(decodedFile);
        if (fileSystemFile.exists() && this.pathMapper != null) {
            mappedPathEntry = this.pathMapper.getLocalFile(decodedFile);
        } else {
            try {
                mappedPathEntry = this.projectScript != null ? DebugSearchEngine.find(decodedFile, this) : DebugSearchEngine.find(this.pathMapper, decodedFile, null, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mappedPathEntry == null) {
            PharPath pharPath = PharPath.getPharPath((IPath)new Path("phar:" + decodedFile));
            if (pharPath != null) {
                DBGpLogger.debug("inbound File '" + decodedFile + "' remapped to phar file");
                mappedFile = "phar:" + decodedFile;
            } else {
                DBGpLogger.debug("inbound File '" + decodedFile + "' Not remapped");
                mappedFile = decodedFile;
            }
        } else {
            mappedFile = mappedPathEntry.getResolvedPath();
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(mappedFile));
            if (file != null) {
                IPath t = file.getRawLocation();
                mappedFile = t != null ? t.toString() : file.getFullPath().toOSString();
            }
            if (DBGpLogger.debugResp()) {
                String mapMsg = "mapped inbound file '" + decodedFile + "' to '" + mappedFile + "'";
                DBGpLogger.debug(mapMsg);
            }
        }
        return mappedFile;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            if (breakpoint instanceof IPHPExceptionBreakpoint) {
                return true;
            }
            boolean support = this.getBreakpointSet().supportsBreakpoint(breakpoint);
            return support;
        }
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
                    if (this.isSuspended() || this.asyncSupported && this.isRunning()) {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add requested immediately");
                        }
                        this.sendBreakpointAddCmd(bp);
                    } else if (this.isRunning()) {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add deferred until suspended");
                        }
                        DBGpBreakpointCmd bpSet = new DBGpBreakpointCmd("breakpoint_set", bp);
                        this.queueBpCmd(bpSet);
                    }
                }
            }
            catch (CoreException e) {
                DBGpLogger.logException("Exception adding breakpoint", this, e);
            }
        }
    }

    private void sendBreakpointAddCmd(DBGpBreakpoint bp) {
        DBGpResponse resp;
        String args = "";
        String debugMsg = null;
        if (bp instanceof DBGpLineBreakpoint) {
            String fileName = bp.getFileName();
            int lineNumber = bp.getLineNumber();
            if (DBGpLogger.debugBP()) {
                debugMsg = "adding breakpoint to file:" + fileName + ", at Line Number: " + lineNumber;
            }
            fileName = this.mapToExternalFileIfRequired(bp);
            args = "-t line -f " + DBGpUtils.getFileURIString(fileName) + " -n " + lineNumber;
        } else if (bp instanceof DBGpExceptionBreakpoint) {
            args = MessageFormat.format("-t exception -x {0}", bp.getException());
        }
        bp.resetConditionChanged();
        DBGpBreakpointCondition condition = new DBGpBreakpointCondition(bp);
        if (condition.getType() == 2) {
            if (debugMsg != null) {
                debugMsg = String.valueOf(debugMsg) + " with expression:" + condition.getExpression();
            }
            args = String.valueOf(args) + " -- " + Base64.encode(this.getSessionEncodingBytes(condition.getExpression()));
        } else if (condition.getType() == 1) {
            if (debugMsg != null) {
                debugMsg = String.valueOf(debugMsg) + " with hit :" + condition.getHitCondition() + condition.getHitValue();
            }
            args = String.valueOf(args) + " -h " + condition.getHitValue() + " -o " + condition.hitCondition;
        }
        if (debugMsg != null) {
            DBGpLogger.debug(debugMsg);
        }
        if (DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("breakpoint_set", args))) {
            String bpId = resp.getTopAttribute("id");
            if (bp instanceof DBGpLineBreakpoint) {
                bp.setID(Integer.parseInt(bpId));
            } else if (bp instanceof DBGpExceptionBreakpoint) {
                ((IPHPExceptionBreakpoint)bp.getBreakpoint()).setId(this, Integer.parseInt(bpId));
            }
            if (DBGpLogger.debugBP()) {
                DBGpLogger.debug("Breakpoint installed with id: " + bpId);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointRemoved(breakpoint, true);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, boolean onlyHandleEnabledBreakpoints) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (onlyHandleEnabledBreakpoints && breakpoint.getMarker().exists() && !breakpoint.isEnabled()) {
                    return;
                }
            }
            catch (CoreException e) {
                DBGpLogger.logException("Exception Removing Breakpoint", this, e);
                return;
            }
            DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
            if (this.isSuspended() || this.asyncSupported && this.isRunning()) {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Immediately removing of breakpoint with ID: " + bp.getID());
                }
                this.sendBreakpointRemoveCmd(bp);
            } else if (this.isRunning()) {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Deferring Removing of breakpoint with ID: " + bp.getID());
                }
                DBGpBreakpointCmd bpRemove = new DBGpBreakpointCmd("breakpoint_remove", bp);
                this.queueBpCmd(bpRemove);
            }
        }
    }

    private void sendBreakpointRemoveCmd(DBGpBreakpoint bp) {
        int bpId = -1;
        if (bp instanceof DBGpLineBreakpoint) {
            bpId = bp.getID();
        } else if (bp instanceof DBGpExceptionBreakpoint) {
            bpId = ((IPHPExceptionBreakpoint)bp.getBreakpoint()).getId(this);
        }
        String args = "-d " + bpId;
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("Removing breakpoint with ID: " + bp.getID());
        }
        DBGpResponse resp = this.session.sendSyncCmd("breakpoint_remove", args);
        DBGpUtils.isGoodDBGpResponse(this, resp);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
        if (!bmgr.isEnabled()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                boolean deltaEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", breakpoint.isEnabled());
                IMarker marker = breakpoint.getMarker();
                DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
                if (bp.hasConditionChanged()) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("condition changed for breakpoint with ID: " + bp.getID());
                    }
                    bp.resetConditionChanged();
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                        this.breakpointAdded(breakpoint);
                    }
                    return;
                }
                if (breakpoint.isEnabled() != deltaEnabled) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("enable state changed for breakpoint with ID: " + bp.getID());
                    }
                    if (breakpoint.isEnabled()) {
                        this.breakpointAdded(breakpoint);
                    } else {
                        this.breakpointRemoved(breakpoint, false);
                    }
                    return;
                }
                HashMap map = marker.getAttributes();
                HashMap deltaMap = delta.getAttributes();
                if (map == null) {
                    map = new HashMap();
                }
                if (deltaMap == null) {
                    deltaMap = new HashMap();
                }
                if (map.entrySet().containsAll(deltaMap.entrySet())) {
                    return;
                }
                if (breakpoint.isEnabled()) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("at least one attribute changed for breakpoint with ID: " + bp.getID());
                    }
                    this.breakpointRemoved(breakpoint, null);
                    this.breakpointAdded(breakpoint);
                }
            }
            catch (CoreException e) {
                DBGpLogger.logException("Exception Changing Breakpoint", this, e);
            }
        }
    }

    public void breakpointHit(String filename, int lineno, String exception) {
        IBreakpoint breakpoint = this.findBreakpointHit(filename, lineno, exception);
        if (breakpoint != null) {
            if (breakpoint instanceof IPHPExceptionBreakpoint) {
                IPHPExceptionBreakpoint exceptionBreakpoint = (IPHPExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setLine(this, lineno);
            }
            this.langThread.setBreakpoints(new IBreakpoint[]{breakpoint});
        } else {
            this.langThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    private IBreakpoint findBreakpointHit(String filename, int lineno, String exception) {
        return this.bpFacade.findBreakpointHit(filename, lineno, exception);
    }

    private void loadPredefinedBreakpoints() {
        IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
        if (!bmgr.isEnabled()) {
            return;
        }
        IBreakpoint[] breakpoints = bmgr.getBreakpoints(this.bpFacade.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.bpFacade.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            if (this.supportsBreakpoint(breakpoints[i])) {
                if (enabled) {
                    this.breakpointAdded(breakpoints[i]);
                } else {
                    this.breakpointRemoved(breakpoints[i], null);
                }
            }
            ++i;
        }
    }

    private void queueBpCmd(DBGpBreakpointCmd bpCmd) {
        if (bpCmd.getCmd().equals("breakpoint_remove")) {
            boolean foundAdd = false;
            if (this.DBGpCmdQueue.size() > 0) {
                int i = this.DBGpCmdQueue.size() - 1;
                while (i >= 0 && !foundAdd) {
                    DBGpBreakpointCmd entry = this.DBGpCmdQueue.get(i);
                    if (entry.getCmd().equals("breakpoint_set") && bpCmd.getBp().getFileName().equals(entry.getBp().getFileName()) && bpCmd.getBp().getLineNumber() == entry.getBp().getLineNumber()) {
                        foundAdd = true;
                        this.DBGpCmdQueue.remove(i);
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("removed a breakpoint command: " + entry);
                        }
                    }
                    --i;
                }
            }
            if (!foundAdd) {
                this.DBGpCmdQueue.add(bpCmd);
            }
        } else {
            this.DBGpCmdQueue.add(bpCmd);
        }
    }

    private void clearQueuedBpCmds() {
        this.DBGpCmdQueue.clear();
    }

    private void processQueuedBpCmds() {
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("processing deferred BP cmds");
        }
        int i = 0;
        while (i < this.DBGpCmdQueue.size()) {
            DBGpBreakpointCmd bpCmd = this.DBGpCmdQueue.get(i);
            if (bpCmd.getCmd().equals("breakpoint_set")) {
                this.sendBreakpointAddCmd(bpCmd.getBp());
            } else if (bpCmd.getCmd().equals("breakpoint_remove")) {
                this.sendBreakpointRemoveCmd(bpCmd.getBp());
            }
            ++i;
        }
        this.DBGpCmdQueue.clear();
    }

    @Override
    public boolean SessionCreated(DBGpSession session) {
        boolean isMine = false;
        isMine = DBGpSessionHandler.getInstance().isCorrectSession(session, this);
        if (isMine) {
            if (this.session == null && !this.isTerminating()) {
                session.setDebugTarget(this);
                this.session = session;
                if (this.hasState(1, 0)) {
                    this.te.signalEvent();
                } else {
                    this.initiateSession();
                }
            } else {
                isMine = false;
            }
        }
        return isMine;
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public boolean isWebLaunch() {
        return this.webLaunch;
    }

    public String getSessionEncoding() {
        if (this.session != null) {
            return this.session.getSessionEncoding();
        }
        return "ISO-8859-1";
    }

    public String getBinaryEncoding() {
        if (this.session != null) {
            return this.session.getBinaryEncoding();
        }
        return DBGpSession.DEFAULT_BINARY_ENCODING;
    }

    public int getUseExtendedProperties() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("UseExtendedProperties", 1);
        }
        return 1;
    }

    private int getMaxDepth() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxDepth", 3);
        }
        return 3;
    }

    public int getMaxChildren() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxChildren", 51);
        }
        return 51;
    }

    public int getMaxData() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxData", 1024);
        }
        return 51;
    }

    private int getCaptureStdout() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("CaptureStdout", 0);
        }
        return 0;
    }

    private int getCaptureStderr() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("CaptureStderr", 0);
        }
        return 0;
    }

    private boolean showGLobals() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getBoolean("ShowGlobals", true);
        }
        return true;
    }

    @Override
    public void setPathMapper(PathMapper pathMapper) {
        this.pathMapper = pathMapper;
    }

    public boolean isRunning() {
        return this.hasState(3);
    }

    public boolean isMultiSessionManaged() {
        return this.multiSessionManaged;
    }

    public void setMultiSessionManaged(boolean multiSessionManaged) {
        this.multiSessionManaged = multiSessionManaged;
    }

    public DBGpSession getSession() {
        return this.session;
    }

    public void setSession(DBGpSession session) {
        this.session = session;
    }

    @Override
    public DebugOutput getOutputBuffer() {
        return this.debugOutput;
    }

    private byte[] getSessionEncodingBytes(String toConvert) {
        byte[] result = null;
        try {
            result = toConvert.getBytes(this.getSessionEncoding());
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("unexpected encoding problem", this, e);
        }
        return result;
    }

    @Override
    public boolean isWaiting() {
        return this.hasState(4);
    }

    private BreakpointSet getBreakpointSet() {
        if (this.breakpointSet == null) {
            this.breakpointSet = new BreakpointSet(PHPLaunchUtilities.getProject(this), !this.webLaunch);
        }
        return this.breakpointSet;
    }

    private static class DBGpBreakpointCmd {
        private String cmd;
        private DBGpBreakpoint bp;

        public DBGpBreakpointCmd(String cmd, DBGpBreakpoint bp) {
            this.cmd = cmd;
            this.bp = bp;
        }

        public String getCmd() {
            return this.cmd;
        }

        public DBGpBreakpoint getBp() {
            return this.bp;
        }
    }

    private static class DBGpBreakpointCondition {
        private String hitCondition;
        private String hitValue;
        private String expression;
        private int type = 0;
        public static final int NONE = 0;
        public static final int HIT = 1;
        public static final int EXPR = 2;
        public static final int INVALID = 3;

        public DBGpBreakpointCondition(DBGpBreakpoint bp) {
            if (bp.isConditional() && bp.isConditionEnabled()) {
                String bpExpression = bp.getExpression().trim();
                if (bpExpression.endsWith(")") && (bpExpression.startsWith("hit(") || bpExpression.startsWith("HIT("))) {
                    if (bpExpression.length() > 5) {
                        this.type = 1;
                        String internal = bpExpression.substring(4, bpExpression.length() - 1).trim();
                        if (internal.startsWith("%")) {
                            this.hitCondition = "%";
                            this.hitValue = internal.substring(1).trim();
                        } else {
                            this.hitCondition = internal.substring(0, 2);
                            if (this.hitCondition.equals("==") || this.hitCondition.equals(">=")) {
                                this.hitValue = internal.substring(2).trim();
                            } else {
                                this.type = 3;
                            }
                        }
                        if (this.type != 3) {
                            try {
                                Integer.parseInt(this.hitValue);
                            }
                            catch (NumberFormatException nfe) {
                                this.type = 3;
                            }
                        }
                    } else {
                        this.type = 3;
                    }
                } else if (bpExpression.length() == 0) {
                    this.type = 0;
                    this.expression = bpExpression;
                } else {
                    this.type = 2;
                    this.expression = bpExpression;
                }
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public String getHitCondition() {
            return this.hitCondition;
        }

        public String getHitValue() {
            return this.hitValue;
        }

        public int getType() {
            return this.type;
        }
    }
}

