/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsKind;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;

public class ZendDebuggerServerSettings
extends AbstractDebuggerSettings {
    public ZendDebuggerServerSettings(String ownerId) {
        super(ownerId);
    }

    public ZendDebuggerServerSettings(String ownerId, Map<String, String> attributes) {
        super(ownerId, attributes);
    }

    @Override
    public String getDebuggerId() {
        return "org.eclipse.php.debug.core.zendDebugger";
    }

    @Override
    public DebuggerSettingsKind getKind() {
        return DebuggerSettingsKind.PHP_SERVER;
    }

    @Override
    protected Map<String, String> createAttributes() {
        ZendDebuggerConfiguration debuggerConf = (ZendDebuggerConfiguration)PHPDebuggersRegistry.getDebuggerConfiguration(this.getDebuggerId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        String clientIp = debuggerConf.getAttribute(PHPDebugCorePreferenceNames.CLIENT_IP);
        attributes.put("clientIp", clientIp != null ? clientIp : "127.0.0.1");
        String clientPort = debuggerConf.getAttribute(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
        attributes.put("clientPort", clientPort != null ? clientPort : "10037");
        String responseTimeout = debuggerConf.getAttribute(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        attributes.put("responseTimeout", responseTimeout != null ? responseTimeout : PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        return attributes;
    }
}

