/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.ui.IFileEditorInput;

public class PHPUnitPropertyTester
extends PropertyTester {
    private static final String PROPERTY = "testablePHP";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!PROPERTY.equals(property)) {
            return false;
        }
        if (!this.isModelElement(receiver)) {
            return false;
        }
        IResource res = this.getReceiverResource(receiver);
        if (res instanceof IProject) {
            try {
                return PHPToolkitUtil.isPHPProject((IProject)((IProject)res));
            }
            catch (CoreException e) {
                return false;
            }
        }
        if (res instanceof IFile) {
            String ext = ((IFile)res).getFileExtension();
            if (ext == null) {
                return false;
            }
            ext = ext.toLowerCase();
            String[] acceptedExts = new String[]{"xml", "php", "php5", "php4"};
            return ext != null && Arrays.asList(acceptedExts).contains(ext);
        }
        return true;
    }

    private IResource getReceiverResource(Object receiver) {
        List list;
        if (receiver instanceof List && (list = (List)receiver).size() == 1) {
            receiver = list.get(0);
        }
        if (receiver instanceof IFileEditorInput) {
            IFileEditorInput ei = (IFileEditorInput)receiver;
            receiver = ei.getFile();
        }
        if (receiver instanceof ISourceModule) {
            return ((ISourceModule)receiver).getResource();
        }
        if (receiver instanceof IFile) {
            return (IResource)receiver;
        }
        if (receiver instanceof IProject) {
            return (IProject)receiver;
        }
        if (receiver instanceof IScriptProject) {
            return ((IScriptProject)receiver).getProject();
        }
        return null;
    }

    private boolean isModelElement(Object receiver) {
        if (receiver instanceof List) {
            List list = (List)receiver;
            for (Object item : list) {
                if (item instanceof IModelElement) continue;
                if (item instanceof IFileEditorInput) {
                    IFileEditorInput fileEditorInput = (IFileEditorInput)item;
                    return PHPToolkitUtil.isPHPFile((IFile)fileEditorInput.getFile());
                }
                if (item instanceof IResource) {
                    IResource folder = (IResource)item;
                    IProject project = folder.getProject();
                    try {
                        return PHPToolkitUtil.isPHPProject((IProject)project);
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log((Throwable)e);
                    }
                }
                return false;
            }
        }
        return true;
    }
}

