/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.actions.OpenEditorAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends OpenEditorAction {
    private int endPosition = 0;
    private String functionName;
    private int startPosition = 0;

    public OpenTestAction(String label, PHPUnitView testRunner, String className, String fileName, int lineNumber) {
        this(label, testRunner, className, fileName, lineNumber, null);
    }

    public OpenTestAction(String label, PHPUnitView testRunner, String className, String fileName, int lineNumber, String method) {
        super(label, testRunner, className, fileName, lineNumber);
        this.functionName = method;
    }

    @Override
    protected IModelElement findElement(IProject project, String elementName, String fileName) throws ModelException {
        if (elementName == null) {
            IMethod function = this.findFunction(project, this.functionName, fileName);
            if (function == null) {
                return null;
            }
            this.startPosition = function.getNameRange().getOffset();
            this.endPosition = this.startPosition + function.getNameRange().getOffset();
            return function;
        }
        IType phpClass = this.findClass(project, elementName, fileName);
        if (phpClass == null) {
            return null;
        }
        ISourceRange nameRange = phpClass.getNameRange();
        this.startPosition = nameRange.getOffset();
        this.endPosition = this.startPosition + nameRange.getLength();
        if (this.functionName == null) {
            return phpClass;
        }
        IMethod function = this.findMethod(phpClass);
        if (function == null) {
            return phpClass;
        }
        this.startPosition = function.getNameRange().getOffset();
        this.endPosition = this.startPosition + function.getNameRange().getLength();
        return function;
    }

    IMethod findMethod(IType phpClass) throws ModelException {
        IMethod[] functions;
        IMethod[] iMethodArray = functions = phpClass.getMethods();
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod function = iMethodArray[n2];
            if (function.getElementName().equalsIgnoreCase(this.functionName)) {
                return function;
            }
            ++n2;
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.functionName != null) {
            return this.findFunction(this.getLaunchedProject(), this.functionName, this.fFileName) != null;
        }
        if (this.fClassName != null) {
            return this.findClass(this.getLaunchedProject(), this.fClassName, this.fFileName) != null;
        }
        return false;
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.endPosition > 0) {
            textEditor.selectAndReveal(this.startPosition, this.endPosition - this.startPosition);
        }
    }
}

