/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.logic.RenameFunction;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameFunctionProcessor
extends AbstractRenameProcessor<IFile>
implements ITextUpdating {
    private static final String RENAME_IS_PROCESSING = PHPRefactoringCoreMessages.getString("RenameFunctionProcessor.0");
    private static final String CREATING_MODIFICATIONS_LABEL = PHPRefactoringCoreMessages.getString("RenameFunctionProcessor.1");
    private static final String FUNCTION_IS_USED = PHPRefactoringCoreMessages.getString("RenameFunctionProcessor.2");
    private static final String ID_RENAME_FUNCTION = "php.refactoring.ui.rename.function";
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final String RENAME_FUNCTION_PROCESSOR_NAME = PHPRefactoringCoreMessages.getString("RenameFunctionProcessor.3");
    private final ASTNode identifier;
    private boolean isUpdateTextualMatches;

    public RenameFunctionProcessor(IFile operatedFile, ASTNode locateNode) {
        super(operatedFile);
        this.identifier = locateNode;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(PHPRefactoringCoreMessages.getString("RenameFunctionProcessor.4"));
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(RENAME_IS_PROCESSING, this.participantFiles.size());
            pm.setTaskName(CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            for (Map.Entry entry : this.participantFiles.entrySet()) {
                IFile file = (IFile)entry.getKey();
                Program program = (Program)entry.getValue();
                RenameFunction rename = new RenameFunction(file, this.getCurrentElementName(), newElementName, this.getUpdateTextualMatches());
                program.accept((Visitor)rename);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                TextFileChange change = this.acquireChange(file, program);
                rename.updateChange(change);
                rootChange.add((Change)change);
            }
            CompositeChange compositeChange = rootChange;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected void collectReferences(Program program, IProgressMonitor pm) {
        final ArrayList list = new ArrayList();
        IScriptProject project = this.identifier.getProgramRoot().getSourceModule().getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)RenameFunctionProcessor.getSearchFlags(false));
        ASTNode node = this.identifier;
        if (this.identifier instanceof Identifier) {
            node = this.identifier.getParent();
        }
        SearchPattern pattern = null;
        int matchMode = 16;
        if (this.isFunctionElement(node)) {
            pattern = SearchPattern.createPattern((String)this.getCurrentElementName(), (int)1, (int)2, (int)matchMode, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            SearchEngine engine = new SearchEngine();
            try {
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        IModelElement element = (IModelElement)match.getElement();
                        list.add(element.getResource());
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        for (IResource file : list) {
            if (!(file instanceof IFile)) continue;
            try {
                this.participantFiles.put((IFile)file, RefactoringUtility.getProgramForFile((IFile)file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isFunctionElement(ASTNode node) {
        return node instanceof FunctionDeclaration || node instanceof FunctionInvocation || node instanceof FunctionName;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.identifier};
    }

    public String getIdentifier() {
        return ID_RENAME_FUNCTION;
    }

    public String getProcessorName() {
        return RENAME_FUNCTION_PROCESSOR_NAME;
    }

    @Override
    public Object getNewElement() {
        return this.getNewElementName();
    }

    @Override
    public String getCurrentElementName() {
        if (this.identifier instanceof Identifier) {
            return ((Identifier)this.identifier).getName();
        }
        if (this.identifier instanceof FunctionDeclaration) {
            return ((FunctionDeclaration)this.identifier).getFunctionName().getName();
        }
        return this.identifier.toString();
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.getCurrentElementName();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        if (PHPElementConciliator.functionAlreadyExists((Program)program, (String)this.getNewElementName())) {
            String message = MessageFormat.format(FUNCTION_IS_USED, key.getName());
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return null;
    }
}

