/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public final class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private final List<String> fCreatedMethods = new ArrayList<String>();
    private final int fInsertPos;
    private final IMethodBinding[] fMethodsToImplement;
    private boolean fDoCreateComments;
    private final ITypeBinding fType;
    private final Program fASTRoot;
    private IDocument fDocument;
    private IType fElement;

    public AddUnimplementedMethodsOperation(Program astRoot, IType element, ITypeBinding type, IMethodBinding[] methodsToImplement, int insertPos, boolean apply, IDocument doc) {
        if (astRoot == null) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a ICompilationUnit");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.fDocument = doc;
        this.fType = type;
        this.fInsertPos = insertPos;
        this.fASTRoot = astRoot;
        this.fMethodsToImplement = methodsToImplement;
        this.fApply = apply;
        this.fElement = element;
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        block21: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                IMethodBinding[] methodsToImplement;
                ListRewrite memberRewriter;
                ITypeBinding currTypeBinding;
                ASTRewrite astRewrite;
                Program cu;
                block20: {
                    monitor.beginTask("", 2);
                    monitor.setTaskName("AddUnimplementedMethodsOperation_description");
                    this.fCreatedMethods.clear();
                    cu = this.fASTRoot.getProgramRoot();
                    AST ast = this.fASTRoot.getAST();
                    astRewrite = ASTRewrite.create((AST)ast);
                    currTypeBinding = this.fType;
                    memberRewriter = null;
                    ASTNode node = null;
                    if (PHPFlags.isAnonymous((int)this.fElement.getFlags())) {
                        node = this.fASTRoot.getElementAt(this.fElement.getSourceRange().getOffset());
                        while (!(node instanceof Program)) {
                            if (!((node = this.fASTRoot.getElementAt(node.getEnd())) instanceof ClassInstanceCreation) || ((ClassInstanceCreation)node).getAnonymousClassDeclaration() == null) continue;
                            node = ((ClassInstanceCreation)node).getAnonymousClassDeclaration();
                            break;
                        }
                    } else {
                        node = this.fASTRoot.getElementAt(this.fElement.getNameRange().getOffset()).getParent();
                    }
                    if (node instanceof ClassDeclaration) {
                        memberRewriter = astRewrite.getListRewrite((ASTNode)((ClassDeclaration)node).getBody(), Block.STATEMENTS_PROPERTY);
                        break block20;
                    }
                    if (node instanceof AnonymousClassDeclaration) {
                        memberRewriter = astRewrite.getListRewrite((ASTNode)((AnonymousClassDeclaration)node).getBody(), Block.STATEMENTS_PROPERTY);
                        break block20;
                    }
                    throw new IllegalArgumentException();
                }
                CodeGenerationSettings settings = new CodeGenerationSettings();
                settings.createComments = this.fDoCreateComments;
                ASTNode insertion = null;
                if (this.fInsertPos != -1) {
                    insertion = CodeGenerationUtils.getNodeToInsertBefore(memberRewriter, this.fInsertPos);
                }
                if ((methodsToImplement = this.fMethodsToImplement) == null) {
                    methodsToImplement = CodeGenerationUtils.getUnimplementedMethods(currTypeBinding);
                }
                IMethodBinding[] iMethodBindingArray = methodsToImplement;
                int n = methodsToImplement.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodBinding curr = iMethodBindingArray[n2];
                    MethodDeclaration stub = CodeGenerationUtils.createImplementationStub(cu, astRewrite, curr, currTypeBinding.getName(), settings, currTypeBinding.isInterface());
                    if (stub != null) {
                        this.fCreatedMethods.add(curr.getKey());
                        if (insertion != null) {
                            memberRewriter.insertBefore((ASTNode)stub, insertion, null);
                        } else {
                            memberRewriter.insertLast((ASTNode)stub, null);
                        }
                    }
                    ++n2;
                }
                TextEdit fEdit = astRewrite.rewriteAST(this.fDocument, null);
                if (!this.fApply) break block21;
                try {
                    fEdit.apply(this.fDocument);
                }
                catch (BadLocationException | MalformedTreeException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 4, "error file content", null));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public void setCreateComments(boolean createComments) {
        this.fDoCreateComments = createComments;
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(keys);
        return keys;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

