/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.selectionactions.Messages;
import org.eclipse.php.internal.ui.editor.selectionactions.SelectionHistory;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private PHPStructuredEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String text, PHPStructuredEditor editor, SelectionHistory history) {
        super(text);
        Assert.isNotNull((Object)((Object)editor));
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fSelectionHistory = history;
    }

    protected StructureSelectionAction() {
        super("");
    }

    public final void run() {
        ISourceModule inputElement = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false);
        if (!(inputElement instanceof ISourceModule) || !inputElement.exists()) {
            return;
        }
        try {
            ISourceRange sourceRange = inputElement.getSourceRange();
            if (sourceRange == null || sourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.StructureSelectionAction_0, (String)Messages.StructureSelectionAction_1);
                return;
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(selection), inputElement);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember((ISourceRange)new SourceRange(selection.getOffset(), selection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
        }
        finally {
            this.fSelectionHistory.listenToSelectionChanges();
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, ISourceModule typeRoot) {
        try {
            Program root = StructureSelectionAction.getAST(typeRoot);
            if (root == null) {
                return oldSourceRange;
            }
            Selection selection = Selection.createFromStartLength((int)oldSourceRange.getOffset(), (int)oldSourceRange.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            root.accept((Visitor)selAnalyzer);
            return this.internalGetNewSelectionRange(oldSourceRange, (ISourceReference)typeRoot, selAnalyzer);
        }
        catch (ModelException e) {
            return new SourceRange(oldSourceRange.getOffset(), oldSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws ModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws ModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws ModelException {
        int offset = nodeToSelect.getStart();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getEnd() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static Program getAST(ISourceModule sr) {
        try {
            return SharedASTProvider.getAST(sr, SharedASTProvider.WAIT_YES, null);
        }
        catch (ModelException modelException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static ISourceRange createSourceRange(int offset, int end) {
        int length = end - offset + 1;
        if (length == 0) {
            length = 1;
        }
        return new SourceRange(Math.max(0, offset), length);
    }

    static ASTNode[] getSiblingNodes(ASTNode node) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent.isChildListProperty()) {
            List siblings = (List)parent.getStructuralProperty(locationInParent);
            return siblings.toArray(new ASTNode[siblings.size()]);
        }
        return null;
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

