/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.compiler;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrEnvironmentFactory;
import org.eclipse.qvtd.umlx.umlx2qvtr.UMLX2QVTr;

public class UMLXCompilerChain
extends QVTrCompilerChain {
    public static final @NonNull String PLUGIN_ID = UMLXCompilerChain.class.getPackage().getName();
    protected final @NonNull UMLX2QVTrCompilerStep umlx2qvtrCompilerStep = this.createUMLX2QVTrCompilerStep();

    public UMLXCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
        super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
    }

    public @NonNull ImperativeTransformation compile(@NonNull Iterable<@NonNull Iterable<@NonNull String>> enforcedOutputNames) throws IOException {
        Resource rResource = this.umlx2qvtrCompilerStep.execute(this.txURI);
        return this.qvtr2qvti(rResource, enforcedOutputNames);
    }

    protected @NonNull UMLX2QVTrCompilerStep createUMLX2QVTrCompilerStep() {
        return new UMLX2QVTrCompilerStep((CompilerChain)this);
    }

    protected static class UMLX2QVTrCompilerStep
    extends AbstractCompilerStep {
        public UMLX2QVTrCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTr");
        }

        public @NonNull Resource execute(@NonNull URI umlxURI) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTrEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource umlxResource = this.environmentFactory.getResourceSet().getResource(umlxURI, true);
                if (umlxResource == null) {
                    throw new CompilerChainException("Failed to load " + umlxURI, new Object[0]);
                }
                Resource qvtrResource = this.createResource();
                UMLX2QVTr umlx2qvtr = new UMLX2QVTr((EnvironmentFactory)this.environmentFactory, umlxResource, qvtrResource);
                umlx2qvtr.transform();
                this.saveResource(qvtrResource);
                Resource resource = qvtrResource;
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }
}

