/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.util.internal.Plugin;
import org.eclipse.rcptt.util.FileUtil;

public class FileContentFactory
implements IReportRenderer.IContentFactory {
    private File root;

    public FileContentFactory(IPath folder) {
        this.root = folder.toFile();
    }

    public FileContentFactory(File folder) {
        this.root = folder;
    }

    public IReportRenderer.IContentFactory createFolder(String name) {
        return new FileContentFactory(new File(this.root, name));
    }

    public OutputStream createFileStream(String fname) {
        File fName = this.getFile(fname);
        try {
            return new BufferedOutputStream(new FileOutputStream(fName));
        }
        catch (FileNotFoundException e) {
            Plugin.UTILS.log((Throwable)e);
            return null;
        }
    }

    public boolean isFileExist(String fname) {
        return this.getFile(fname).exists();
    }

    private File getFile(String fname) {
        File folder = this.root;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File fName = new File(folder, fname);
        return fName;
    }

    public List<String> matchFiles(String fname) {
        HashSet<String> result = new HashSet<String>();
        if (this.isFileExist(fname)) {
            result.add(fname);
        }
        try {
            this.traverse(this.root, fname, result);
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
        return new ArrayList<String>(result);
    }

    private void traverse(File dir, String fname, Set<String> result) {
        File[] listFiles;
        File[] fileArray = listFiles = dir.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = this.root.toURI().relativize(file.toURI()).toString();
            if (Pattern.matches(fname, name)) {
                result.add(name);
            }
            if (file.isDirectory()) {
                this.traverse(new File(dir.getAbsolutePath(), name), fname, result);
            }
            ++n2;
        }
    }

    public void removeFileOrFolder(String name) {
        File file = this.getFile(name);
        if (file.exists()) {
            FileUtil.deleteFile((File)file, (boolean)true);
        }
    }
}

